/*
 * vo_setup()
 * Allocate frame buffers
 */

int vo_setup( mpeg2dec_t *mpeg2dec, int width, int height )
{
  int i, size = width * height / 4;
  uint8_t *buffer;

  buffer = malloc( size * 6 * 3 );
  if( buffer == NULL )	return 1;

  for( i = 0; i < 3; i++ )
  {
	mpeg2dec->frame[i].base[0] = buffer;
	mpeg2dec->frame[i].base[1] = buffer + size * 4;
	mpeg2dec->frame[i].base[2] = buffer + size * 5;
	mpeg2dec->frame[i].copy = NULL;
	buffer += size * 6;
  }

  mpeg2dec->prediction = 1;
  return 0;
}

/*
 * vo_exit()
 * Free frame buffers
 */

void vo_exit( mpeg2dec_t *mpeg2dec )
{
  free( mpeg2dec->frame[0].base[0] );
}

/*
 * vo_field()
 * Only present, to avoid removing the call from decode.c
 */

void vo_field( vo_frame_t *frame, int flags )
{
}

/*
 * vo_get_frame()
 */

vo_frame_t *vo_get_frame( mpeg2dec_t *mpeg2dec, int flags )
{
  if( flags & VO_PREDICTION_FLAG )
  {
	mpeg2dec->prediction ^= 1;
	return &mpeg2dec->frame[mpeg2dec->prediction];
  }

  return &mpeg2dec->frame[2];
}

/*
 * vo_draw()
 */

void vo_draw( vo_frame_t *frame, uint8_t **image )
{
  image[0] = frame->base[0];
  image[1] = frame->base[1];
  image[2] = frame->base[2];
}
