#ifndef INC_libmpg123_h
#define INC_libmpg123_h

#include <inttypes.h>
#include "mpg123.h"
#include "mpglib.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Definitions
 */

#define	MPG123_OK			0
#define	MPG123_ERROR			-1
#define	MPG123_MOREDATA			-2

/*
 * Flags ( for accelaration )
 */

	/** Bits containing CPU info */
#define	MMACCEL_CPUMASK			0xF0000000
	/** Shift for CPU info */
#define	MMACCEL_CPUSHIFT		28

	/** Intel MMX and compatible. */
#define MMACCEL_X86_MMX			0x0001

	/** Pentium ( and clones ) */
#define	MMACCEL_CPU_586			( 5 << MMACCEL_CPUSHIFT )
	/* Pentium II ( and clones ) */
#define	MMACCEL_CPU_686			( 6 << MMACCEL_CPUSHIFT )

/*
 * Types
 */

typedef struct
{
    int (*read)( void *priv, void *data, int size );
} mpg123_reader_t;

typedef struct mpstr mpg123_t;


/*
 * Prototypes
 */

	/*
	 * Initialize libmpg123
	 */
int	MPG123_Init( mpg123_t *mpg123, uint32_t flags );

	/*
	 * Free libmp123
	 */
void	MPG123_Exit( mpg123_t *mpg123 );

	/*
	 * Decode one frame
	 */
int	MPG123_DecodeFrame( mpg123_t *mpg123, unsigned char *out, int *done, mpg123_reader_t *reader, void *priv );

#ifdef __cplusplus
}
#endif

#endif
