/***********************************************************

	Win32 emulation code. Functions that emulate
	responses from corresponding Win32 API calls.
         Since we are not going to be able to load 
       virtually any DLL, we can only implement this
      much, adding needed functions with each new codec.
      
      Basic principle of implementation: it's not good
      for DLL to know too much about its environment.

************************************************************/

#include <config.h>

#include "win32.h"
#include <stdio.h>
#include <stddef.h>
#include <pthread.h>
#include <errno.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else
#include <stdlib.h>
#endif
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/timeb.h>

#include <wine/winbase.h>
#include <wine/winreg.h>
#include <wine/winnt.h>
#include <wine/winerror.h>
#include <wine/debugtools.h>
#include <wine/module.h>

#include <registry.h>
#include <loader.h>
#include <com.h>

static void do_cpuid(unsigned int *regs)
{
  unsigned int ax;
  ax=1;
    __asm__ __volatile__(
	"pushl %%ebx; pushl %%ecx; pushl %%edx; "
        ".byte  0x0f, 0xa2;"
        "movl   %%eax, (%2);"
        "movl   %%ebx, 4(%2);"
        "movl   %%ecx, 8(%2);"
        "movl   %%edx, 12(%2);"
	"popl %%edx; popl %%ecx; popl %%ebx; "
        : "=a" (ax)
    :  "0" (ax), "S" (&regs));
}
static unsigned int c_localcount_tsc()
{
    int a;
    __asm__ __volatile__("rdtsc\n\t"
    :"=a"(a)
    :
    :"edx");
    return a;
}
static void c_longcount_tsc(long long* z)
{
    __asm__ __volatile__(
    "pushl %%ebx\n\t"
    "movl %%eax, %%ebx\n\t"
    "rdtsc\n\t"
    "movl %%eax, 0(%%ebx)\n\t"
    "movl %%edx, 4(%%ebx)\n\t"
    "popl %%ebx\n\t"
    ::"a"(z));
}    
#include <sys/time.h>
#include <unistd.h>
static unsigned int c_localcount_notsc()
{
    struct timeval tv;
    unsigned limit=~0;
    limit/=1000000;
    gettimeofday(&tv, 0);
    return limit*tv.tv_usec;
}
static void c_longcount_notsc(long long* z)
{
    struct timeval tv;
    unsigned long long result;
    unsigned limit=~0;
    if(!z)return;
    limit/=1000000;
    gettimeofday(&tv, 0);
    result=tv.tv_sec;
    result<<=32;
    result+=limit*tv.tv_usec;
    *z=result;
}
static unsigned int localcount_stub();
static void longcount_stub(long long*);
static unsigned int (*localcount)()=localcount_stub;
static void (*longcount)(long long*)=longcount_stub;

static unsigned int localcount_stub()
{
    unsigned int regs[4];
    do_cpuid(regs);
    if ((regs[3] & 0x00000010) == 0) 
    {
	localcount=c_localcount_tsc;
	longcount=c_longcount_tsc;
    }	
    else 
    {
    	localcount=c_localcount_notsc;
	longcount=c_longcount_notsc;
    }
    return localcount();
}
static void longcount_stub(long long* z)
{
    unsigned int regs[4];
    do_cpuid(regs);
    if ((regs[3] & 0x00000010) == 0) 
    {
	localcount=c_localcount_tsc;
	longcount=c_longcount_tsc;
    }	
    else 
    {
    	localcount=c_localcount_notsc;
	longcount=c_longcount_notsc;
    }
    longcount(z);
}

int LOADER_DEBUG=0;
void dbgprintf(char* fmt, ...)
{
    if(LOADER_DEBUG)
    {
	FILE* f;
	va_list va;
        va_start(va, fmt);
	f=fopen("./log", "a");
        vprintf(fmt, va);
    	if(f)
	{
	    vfprintf(f, fmt, va);
	    fsync(fileno(f));
    	    fclose(f);
	}
	va_end(va);
    }
}    
char export_names[500][30]={
"name1",
//"name2",
//"name3"
};
//#define min(x,y) ((x)<(y)?(x):(y))

static unsigned char* heap=NULL; 
static int heap_counter=0;
void test_heap()
{
    int offset=0;	
    if(heap==0)
	return;
    while(offset<heap_counter)
    {
	if(*(int*)(heap+offset)!=0x433476)
	{
	    printf("Heap corruption at address %d\n", offset);
	    return;
	}
	offset+=8+*(int*)(heap+offset+4);
    }
    for(;offset<min(offset+1000, 20000000); offset++)
	if(heap[offset]!=0xCC)
	    {
		printf("Free heap corruption at address %d\n", offset);
	}	    
}
#undef MEMORY_DEBUG

#ifdef MEMORY_DEBUG

void* my_mreq(int size, int to_zero)
{
    static int test=0;
    test++;
    if(test%10==0)printf("Memory: %d bytes allocated\n", heap_counter);
//    test_heap();
    if(heap==NULL)
    {
	heap=malloc(20000000);
	memset(heap, 0xCC,20000000);
    }
    if(heap==0)
    {
	printf("No enough memory\n");
	return 0;
    }	
    if(heap_counter+size>20000000)
    {
	printf("No enough memory\n");
	return 0;
    }	
    *(int*)(heap+heap_counter)=0x433476;
    heap_counter+=4;
    *(int*)(heap+heap_counter)=size;
    heap_counter+=4;
    printf("Allocated %d bytes of memory: sys %d, user %d-%d\n", size, heap_counter-8, heap_counter, heap_counter+size);
    if(to_zero)
    	memset(heap+heap_counter, 0, size);	    
    heap_counter+=size;
    return heap+heap_counter-size;	
}
int my_release(char* memory)
{
//    test_heap();
    if(memory==NULL)
    {
	printf("ERROR: free(0)\n");
	return 0;
    }	
    if(*(int*)(memory-8)!=0x433476)
    {
	printf("MEMORY CORRUPTION !!!!!!!!!!!!!!!!!!!\n");
	return 0;
    }
    printf("Freed %d bytes of memory\n", *(int*)(memory-4));
//    memset(memory-8, *(int*)(memory-4), 0xCC);
    return 0;
}    	     

#else
void* my_mreq(int size, int to_zero)
{
    void* answer; 
    if(to_zero)
	answer=calloc(size+4, 1);
    else
	answer=malloc(size+4);
    *(int*)answer=size;
    return (int*)answer+1;
}	
int my_release(char* memory)
{
    if(memory==0)return 0;
    free(memory-4);
    return 0;
}
#endif
int my_size(char* memory)
{
    return *(int*)(memory-4);
}    

extern int unk_exp1;
char extcode[20000];// place for 200 unresolved exports
int pos=0;

int WINAPI ext_unknown()
{
    printf("Unknown func called\n");
    return 0;
}    
int WINAPI expIsBadWritePtr(void* ptr, unsigned int count)
{
    dbgprintf("IsBadWritePtr(%x, %x)\n", ptr, count);
    if(count==0)
	return 0;
    if(ptr==0)
        return 1;
    return 0;
}
int WINAPI expIsBadReadPtr(void* ptr, unsigned int count)
{
    dbgprintf("IsBadReadPtr(%x, %x)\n", ptr, count);
    if(count==0)
	return 0;
    if(ptr==0)
        return 1;
    return 0;
}
void* CDECL expmalloc(int size)
{
//printf("malloc");
//    return malloc(size);
    void* result=my_mreq(size,0);
    dbgprintf("malloc(%x) addr (%x)\n", size,result);
    if(result==0)
    {
	dbgprintf("returns 0\n");
	printf("WARNING: malloc() failed\n");
    }	
    return result;
}
void CDECL expfree(void* mem)
{
//    return free(mem);
    dbgprintf("free(%x)\n", mem);
    my_release(mem);
}
void* CDECL expnew(int size)
{
//    printf("NEW:: Call from address %08x\n STACK DUMP:\n", *(-1+(int*)&size));
//    printf("%08x %08x %08x %08x\n",
//    size, *(1+(int*)&size),
//    *(2+(int*)&size),*(3+(int*)&size));
    void* result=expmalloc(size);
    dbgprintf("new(%x)\n", size);
    if(result==0)
    {
	dbgprintf("returns 0\n");
	printf("WARNING: malloc() failed\n");
    }	
    return result;

}    
int CDECL expdelete(void* memory)
{
    dbgprintf("delete(%x)\n", memory);
    expfree(memory);
    return 0;
}
int WINAPI expDisableThreadLibraryCalls(int module)
{
    dbgprintf("DisableThreadLibraryCalls(%x)\n", module);
    return 0;
}    
int CDECL exp_initterm(int v1, int v2)
{
    return 0;
}    

typedef struct {
    unsigned int     	uDriverSignature;
    void*        	hDriverModule;
    void*    		DriverProc;
    unsigned int        dwDriverID;
} DRVR;

void* WINAPI expGetDriverModuleHandle(DRVR* pdrv)
{
    dbgprintf("GetDriverModuleHandle(%x)\n", pdrv);
    if (pdrv==NULL) return NULL;
    return pdrv->hDriverModule;
}

void* WINAPI expGetModuleHandleA(const char* name)
{
	WINE_MODREF* wm;
        dbgprintf("GetModuleHandleA(%s)\n", name);
	if(!name)return 0;
        wm=MODULE_FindModule(name);
        if(wm==0)return 0;
        return (void*)(wm->module);
}
struct th_list_t;
typedef struct th_list_t{
int id;
void* thread;
struct th_list_t* next;
struct th_list_t* prev;
}th_list;

static th_list* list=NULL;



void* WINAPI expCreateThread(void* pSecAttr, long dwStackSize, void* lpStartAddress,
	void* lpParameter, long dwFlags, long* dwThreadId)
{
    pthread_t *pth;
//    printf("CreateThread:");
    pth=my_mreq(sizeof(pthread_t), 0);
    dbgprintf("pthread_create\n");
    pthread_create(pth, NULL, (void*(*)(void*))lpStartAddress, lpParameter);
    if(dwFlags)
	dbgprintf( "WARNING: CreateThread flags not supported\n");
    if(dwThreadId)
	*dwThreadId=(long)pth;
    dbgprintf( "Created thread %08x\n", pth);
    if(list==NULL)
    {
	list=my_mreq(sizeof(th_list), 1);
	list->next=list->prev=NULL;
    }
    else
    {
	list->next=my_mreq(sizeof(th_list), 0);
	list->next->prev=list;
	list->next->next=NULL;
	list=list->next;
    }		
    list->thread=pth;
    return pth;
}

struct mutex_list_t;

struct mutex_list_t
{
    char type;
    pthread_mutex_t *pm;
    pthread_cond_t  *pc;
    char state;
    char reset;
    char name[64];
    int  semaphore;
    struct mutex_list_t* next;
    struct mutex_list_t* prev;
};
typedef struct mutex_list_t mutex_list;
static mutex_list* mlist=NULL; 
void* WINAPI expCreateEventA(void* pSecAttr, char bManualReset, 
    char bInitialState, const char* name)
{
    pthread_mutex_t *pm;
    pthread_cond_t  *pc;
    if(mlist!=NULL)
    {
	mutex_list* pp=mlist;
	if(name!=NULL)
	do
	{
	    if((strcmp(pp->name, name)==0) && (pp->type==0))
		return pp->pm;
	}while(pp=pp->prev);
    }	
    pm=my_mreq(sizeof(pthread_mutex_t), 0);
    pthread_mutex_init(pm, NULL);
    pc=my_mreq(sizeof(pthread_cond_t), 0);
    pthread_cond_init(pc, NULL);
    if(mlist==NULL)
    {
	mlist=my_mreq(sizeof(mutex_list), 00);
	mlist->next=mlist->prev=NULL;
    }
    else
    {
	mlist->next=my_mreq(sizeof(mutex_list), 00);
	mlist->next->prev=mlist;
	mlist->next->next=NULL;
	mlist=mlist->next;
    }
    mlist->type=0; /* Type Event */
    mlist->pm=pm;
    mlist->pc=pc;
    mlist->state=bInitialState;
    mlist->reset=bManualReset;
    if(name!=NULL)
        strncpy(mlist->name, name, 64);
	else
	mlist->name[0]=0;
    if(pm==NULL)
	dbgprintf("ERROR::: CreateEventA failure\n");
/*
    if(bInitialState)
        pthread_mutex_lock(pm);
*/
    dbgprintf("CreateEvent %x\n",mlist);
    return mlist;
}    

void* WINAPI expSetEvent(void* event)
{
    mutex_list *ml = (mutex_list *)event;
    dbgprintf("SetEvent %x\n", event);
    pthread_mutex_lock(ml->pm);
    if (ml->state == 0) {
	ml->state = 1;
	pthread_cond_signal(ml->pc);
    }
    pthread_mutex_unlock(ml->pm);

    return (void *)1;
}
void* WINAPI expResetEvent(void* event)
{
    mutex_list *ml = (mutex_list *)event;
    dbgprintf("ResetEvent %x\n", event);
    pthread_mutex_lock(ml->pm);
    ml->state = 0;
    pthread_mutex_unlock(ml->pm);    

    return (void *)1;
}

void* WINAPI expWaitForSingleObject(void* object, int duration)
{
    mutex_list *ml = (mutex_list *)object;
    int ret;
    mutex_list* pp=mlist;
    dbgprintf("WaitForSingleObject: %x duration %d\n",object, duration);
    do {
	if (pp == NULL) dbgprintf("NotFound\n");
	if((pp->pm, mlist->pm)==0)
		break;;
     }while(pp=pp->prev);
    

    pthread_mutex_lock(ml->pm);

    switch(ml->type) {
      case 0: /* Event */
	if (duration == 0) { /* Check Only */
		if (ml->state == 1) ret = WAIT_FAILED;
		else                   ret = WAIT_OBJECT_0;
	}
	if (duration == -1) { /* INFINITE */
		if (ml->state == 0)
			pthread_cond_wait(ml->pc,ml->pm);
		if (ml->reset)
			ml->state = 0;
		ret = WAIT_OBJECT_0;
	}
	if (duration > 0) {  /* Timed Wait */
		struct timespec abstime;
		abstime.tv_sec=0;
		abstime.tv_nsec = duration*1000;
		if (ml->state == 0)
			ret=pthread_cond_timedwait(ml->pc,ml->pm,&abstime);
		if (ret == ETIMEDOUT) ret = WAIT_TIMEOUT;
		else                  ret = WAIT_OBJECT_0;
		if (ml->reset)
			ml->state = 0;	
	}
        break;
      case 1:  /* Semaphore */
        if (duration == 0) {
		if(ml->semaphore==0) ret = WAIT_FAILED;
		else {
			ml->semaphore++;
			ret = WAIT_OBJECT_0;
		}
        }
	if (duration == -1) {
		if (ml->semaphore==0)
			pthread_cond_wait(ml->pc,ml->pm);
		ml->semaphore--;
	}
        break;
    }
    pthread_mutex_unlock(ml->pm);

    dbgprintf("WaitForSingleObject: %x Done %x \n",ml,ret);
    return (void *)ret;
}    

static BYTE PF[64] = {0,};

void WINAPI expGetSystemInfo(SYSTEM_INFO* si)
{
    	/* FIXME: better values for the two entries below... */
	static int cache = 0;
	static SYSTEM_INFO cachedsi;
	unsigned int regs[4];
	HKEY	xhkey=0,hkey;
        dbgprintf("GetSystemInfo()\n");

	if (cache) {
		memcpy(si,&cachedsi,sizeof(*si));
		return;
	}
	memset(PF,0,sizeof(PF));

	cachedsi.u.s.wProcessorArchitecture     = PROCESSOR_ARCHITECTURE_INTEL;
	cachedsi.dwPageSize 			= getpagesize();

	/* FIXME: better values for the two entries below... */
	cachedsi.lpMinimumApplicationAddress	= (void *)0x00000000;
	cachedsi.lpMaximumApplicationAddress	= (void *)0x7FFFFFFF;
	cachedsi.dwActiveProcessorMask		= 1;
	cachedsi.dwNumberOfProcessors		= 1;
	cachedsi.dwProcessorType		= PROCESSOR_INTEL_386;
	cachedsi.dwAllocationGranularity	= 0x10000;
	cachedsi.wProcessorLevel		= 5; /* pentium */
	cachedsi.wProcessorRevision		= 0x0101;
	
#ifdef __FreeBSD__
        cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
        cachedsi.wProcessorLevel= 5;
	PF[PF_COMPARE_EXCHANGE_DOUBLE] = TRUE;
	do_cpuid(regs);
	if (regs[3] & 0x00800000)
          PF[PF_MMX_INSTRUCTIONS_AVAILABLE] = TRUE;
        cachedsi.dwNumberOfProcessors=1;
#else
	{
	char buf[20];
	char line[200];
	FILE *f = fopen ("/proc/cpuinfo", "r");

	if (!f)
		return;
        xhkey = 0;
	while (fgets(line,200,f)!=NULL) {
		char	*s,*value;

		/* NOTE: the ':' is the only character we can rely on */
		if (!(value = strchr(line,':')))
			continue;
		/* terminate the valuename */
		*value++ = '\0';
		/* skip any leading spaces */
		while (*value==' ') value++;
		if ((s=strchr(value,'\n')))
			*s='\0';

		/* 2.1 method */
		if (!lstrncmpiA(line, "cpu family",strlen("cpu family"))) {
			if (isdigit (value[0])) {
				switch (value[0] - '0') {
				case 3: cachedsi.dwProcessorType = PROCESSOR_INTEL_386;
					cachedsi.wProcessorLevel= 3;
					break;
				case 4: cachedsi.dwProcessorType = PROCESSOR_INTEL_486;
					cachedsi.wProcessorLevel= 4;
					break;
				case 5: cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				case 6: cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				default:cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				}
			}
			/* set the CPU type of the current processor */
			sprintf(buf,"CPU %ld",cachedsi.dwProcessorType);
			continue;
		}
		/* old 2.0 method */
		if (!lstrncmpiA(line, "cpu",strlen("cpu"))) {
			if (	isdigit (value[0]) && value[1] == '8' && 
				value[2] == '6' && value[3] == 0
			) {
				switch (value[0] - '0') {
				case 3: cachedsi.dwProcessorType = PROCESSOR_INTEL_386;
					cachedsi.wProcessorLevel= 3;
					break;
				case 4: cachedsi.dwProcessorType = PROCESSOR_INTEL_486;
					cachedsi.wProcessorLevel= 4;
					break;
				case 5: cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				case 6: cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				default:cachedsi.dwProcessorType = PROCESSOR_INTEL_PENTIUM;
					cachedsi.wProcessorLevel= 5;
					break;
				}
			}
			/* set the CPU type of the current processor */
			sprintf(buf,"CPU %ld",cachedsi.dwProcessorType);
			continue;
		}
		if (!lstrncmpiA(line,"fdiv_bug",strlen("fdiv_bug"))) {
			if (!lstrncmpiA(value,"yes",3))
				PF[PF_FLOATING_POINT_PRECISION_ERRATA] = TRUE;

			continue;
		}
		if (!lstrncmpiA(line,"fpu",strlen("fpu"))) {
			if (!lstrncmpiA(value,"no",2))
				PF[PF_FLOATING_POINT_EMULATED] = TRUE;

			continue;
		}
		if (!lstrncmpiA(line,"processor",strlen("processor"))) {
			/* processor number counts up...*/
			int	x;

			if (sscanf(value,"%d",&x))
				if (x+1>cachedsi.dwNumberOfProcessors)
					cachedsi.dwNumberOfProcessors=x+1;

			/* Create a new processor subkey on a multiprocessor
			 * system
			 */
			sprintf(buf,"%d",x);
		}
		if (!lstrncmpiA(line,"stepping",strlen("stepping"))) {
			int	x;

			if (sscanf(value,"%d",&x))
				cachedsi.wProcessorRevision = x;
		}
		if 
		( (!lstrncmpiA(line,"flags",strlen("flags"))) 
		|| (!lstrncmpiA(line,"features",strlen("features"))) )
		{
			if (strstr(value,"cx8"))
				PF[PF_COMPARE_EXCHANGE_DOUBLE] = TRUE;
			if (strstr(value,"mmx"))
				PF[PF_MMX_INSTRUCTIONS_AVAILABLE] = TRUE;

		}
	}
	fclose (f);
/*
 *	ad hoc fix for smp machines.
 *	some problems on WaitForSingleObject,CreateEvent,SetEvent
 *			CreateThread ...etc..
 *
 */
        cachedsi.dwNumberOfProcessors=1;
	}
#endif /* __FreeBSD__ */
	memcpy(si,&cachedsi,sizeof(*si));
}

long WINAPI expGetVersion()
{
    dbgprintf("GetVersion()\n");
    return 0xC0000A04;//Windows 98
}    

HANDLE WINAPI expHeapCreate(long flags, long init_size, long max_size)
{
//    printf("HeapCreate:");
    dbgprintf("HeapCreate(%X, %d, %d)\n", flags, init_size, max_size); 
    if(init_size==0)
    	return (HANDLE)my_mreq(0x110000, 0);
    else
	return (HANDLE)my_mreq(init_size, 0);
}		
void* WINAPI expHeapAlloc(HANDLE heap, int flags, int size)
{
    void* z;
//    printf("HeapAlloc:");
    z=my_mreq(size, flags&8);    
//    z=HeapAlloc(heap,flags,size);
    if(z==0)
	printf("HeapAlloc failure\n");
    dbgprintf("HeapAlloc(%x, %x, %x) addr %x\n", heap, flags, size,z); 
    return z;
}
long WINAPI expHeapDestroy(void* heap)
{
    dbgprintf("HeapDestroy(%x)\n", heap); 
    my_release(heap);
    return 1;
}

long WINAPI expHeapFree(int arg1, int arg2, void* ptr)
{
    dbgprintf("HeapFree(%X, %X, %X)\n", arg1, arg2, ptr);
    my_release(ptr);
    return 1;
}    	
long WINAPI expHeapSize(int heap, int flags, void* pointer)
{
    dbgprintf("HeapSize(%X, %X, %X)\n", heap, flags, pointer);
    return my_size(pointer);
} 
long WINAPI expGetProcessHeap(void)
{
    return 1;
}    
void* WINAPI expVirtualAlloc(void* v1, long v2, long v3, long v4)
{
    void* z;
    dbgprintf("VirtualAlloc(%x %d %d %d) \n",v1,v2,v3,v4);
    z=VirtualAlloc(v1, v2, v3, v4);
    if(z==0)
	printf("VirtualAlloc failure\n");
    return z;
}
int WINAPI expVirtualFree(void* v1, int v2, int v3)
{
    dbgprintf("VirtualFree(%x %d %d) \n",v1,v2,v3);
    return VirtualFree(v1,v2,v3);
}    
struct CRITSECT 
{
    pthread_t id;
    pthread_mutex_t mutex;
    int locked;
};
void WINAPI expInitializeCriticalSection(CRITICAL_SECTION* c)
{
    struct CRITSECT cs;
    dbgprintf("InitCriticalSection(%X) \n", c);
/*    if(sizeof(pthread_mutex_t)>sizeof(CRITICAL_SECTION))
    {
	printf(" ERROR:::: sizeof(pthread_mutex_t) is %d, expected <=%d!\n",
	     sizeof(pthread_mutex_t), sizeof(CRITICAL_SECTION));
	return;
    }*/
/*    pthread_mutex_init((pthread_mutex_t*)c, NULL);   */
    pthread_mutex_init(&cs.mutex, NULL);   
    cs.locked=0;
    *(void**)c=malloc(sizeof cs);
    memcpy(*(void**)c, &cs, sizeof cs);
    return;
}          
void WINAPI expEnterCriticalSection(CRITICAL_SECTION* c)
{
    struct CRITSECT* cs=*(struct CRITSECT**)c;
    dbgprintf("EnterCriticalSection(%X) \n",c);
//    cs.id=pthread_self();
    if(cs->locked)
	if(cs->id==pthread_self())
	    return;
    pthread_mutex_lock(&(cs->mutex));
    cs->locked=1;
    cs->id=pthread_self();
    return;
}          
void WINAPI expLeaveCriticalSection(CRITICAL_SECTION* c)
{
    struct CRITSECT* cs=*(struct CRITSECT**)c;
//    struct CRITSECT* cs=(struct CRITSECT*)c;
    dbgprintf("LeaveCriticalSection(%X) \n",c);
    cs->locked=0;
    pthread_mutex_unlock(&(cs->mutex));
    return;
}
void WINAPI expDeleteCriticalSection(CRITICAL_SECTION *c)
{
    struct CRITSECT* cs=*(struct CRITSECT**)c;
//    struct CRITSECT* cs=(struct CRITSECT*)c;
    dbgprintf("DeleteCriticalSection(%X) \n",c);
    pthread_mutex_destroy(&(cs->mutex));
    free(cs);
    return;
}
int WINAPI expGetCurrentThreadId()
{
    dbgprintf("GetCurrentThreadId() \n");
    return getpid();
}                  
struct tls_s;
typedef struct tls_s
{
    void* value;
    int used;
    struct tls_s* prev;
    struct tls_s* next;
}tls_t;

tls_t* g_tls=NULL;    
    
void* WINAPI expTlsAlloc()
{
    dbgprintf("TlsAlloc \n");
    if(g_tls==NULL)
    {
	g_tls=my_mreq(sizeof(tls_t), 0);
	g_tls->next=g_tls->prev=NULL;
    }
    else
    {
	g_tls->next=my_mreq(sizeof(tls_t), 0);
	g_tls->next->prev=g_tls;
	g_tls->next->next=NULL;
	g_tls=g_tls->next;
    }
    return g_tls;
    
}

int WINAPI expTlsSetValue(tls_t* index, void* value)
{
    dbgprintf("TlsSetVal(%X %X) \n", index, value );
    if(index==0)
	return 0;
    index->value=value;
    return 1;
}
void* WINAPI expTlsGetValue(tls_t* index)
{
    dbgprintf("TlsGetVal(%X) \n", index );
    if(index==0)
	return 0;
    return index->value;	
}
int WINAPI expTlsFree(tls_t* index)
{
    dbgprintf("TlsFree(%X) \n", index);
    if(index==0)
	return 0;
    if(index->next)
	index->next->prev=index->prev;
    if(index->prev)
        index->prev->next=index->next;
    my_release((void*)index);
    return 1;
}     

void* WINAPI expLocalAlloc(int flags, int size)
{
    void* z;
    dbgprintf("LocalAlloc(%d, flags %X)\n", size, flags);
    if(flags&GMEM_ZEROINIT)
	z=my_mreq(size, 1);
    else
	z=my_mreq(size, 0);
    if(z==0)
	printf("LocalAlloc() failed\n");
    return z;
}	
void* WINAPI expLocalLock(void* z)
{
   dbgprintf("LocalLock\n");
    return z;
}    
void* WINAPI expGlobalAlloc(int flags, int size)
{
    void* z;
     dbgprintf("GlobalAlloc(%d, flags 0x%X)\n", size, flags);
    if(flags&GMEM_ZEROINIT)
	z=calloc(size, 1);	
//	z=my_mreq(size, 1);
	else
	z=malloc(size);
//	z=my_mreq(size, 0);
    if(z==0)
	printf("GlobalAlloc() failed\n");
    return z;
}	
void* WINAPI expGlobalLock(void* z)
{
     dbgprintf("GlobalLock\n");
    return z;
}    

int WINAPI expLoadStringA(long instance, long  id, void* buf, long size)
{
    dbgprintf("LoadStringA\n");
    return LoadStringA(instance, id, buf, size);
}    	    	

long WINAPI expMultiByteToWideChar(long v1, long v2, char* s1, long siz1, char* s2, int siz2)
{
#warning FIXME
    dbgprintf("MB2WCh\n");
    dbgprintf("WARNING: Unsupported call: MBToWCh %s\n", s1);       
    if(s2==0)
	return 1;
    s2[0]=s2[1]=0;
    return 1;
}
long WINAPI expWideCharToMultiByte(long v1, long v2, short* s1, long siz1, char* s2, int siz2, char* c3, int* siz3)
{
    int result;
    dbgprintf("WCh2MB\n");
    result=WideCharToMultiByte(v1, v2, s1, siz1, s2, siz2, c3, siz3);
    dbgprintf("=> %d\n", result);
    return result;
}
long WINAPI expGetVersionExA(OSVERSIONINFOA* c)
{
    dbgprintf("GetVersionExA\n");
    c->dwMajorVersion=4;
    c->dwMinorVersion=10;
    c->dwBuildNumber=0x40a07ce;
    c->dwPlatformId=VER_PLATFORM_WIN32_WINDOWS;
    strcpy(c->szCSDVersion, "Win98");
    return 1;
}        
HANDLE WINAPI expCreateSemaphoreA(char* v1, long init_count, long max_count, char* name)
{
    pthread_mutex_t *pm;
    pthread_cond_t  *pc;
    if(mlist!=NULL)
    {
	mutex_list* pp=mlist;
	if(name!=NULL)
	do
	{
	    if((strcmp(pp->name, name)==0) && (pp->type==1))
		return (HANDLE)mlist;
	}while(pp=pp->prev);
    }	
    pm=my_mreq(sizeof(pthread_mutex_t), 0);
    pthread_mutex_init(pm, NULL);
    pc=my_mreq(sizeof(pthread_cond_t), 0);
    pthread_cond_init(pc, NULL);
    if(mlist==NULL)
    {
	mlist=my_mreq(sizeof(mutex_list), 00);
	mlist->next=mlist->prev=NULL;
    }
    else
    {
	mlist->next=my_mreq(sizeof(mutex_list), 00);
	mlist->next->prev=mlist;
	mlist->next->next=NULL;
	mlist=mlist->next;
    }
    mlist->type=1; /* Type Semaphore */
    mlist->pm=pm;
    mlist->pc=pc;
    mlist->state=0;
    mlist->reset=0;
    mlist->semaphore=init_count;
    if(name!=NULL)
        strncpy(mlist->name, name, 64);
    else
	mlist->name[0]=0;
    if(pm==NULL)
	dbgprintf("ERROR::: CreateSemaphoreA failure\n");
    dbgprintf("CreateSemaphoreA %x init %d\n",mlist,init_count);

    return (HANDLE)mlist;
}
        
long WINAPI expReleaseSemaphore(long hsem, long increment, long* prev_count)
{
// The state of a semaphore object is signaled when its count 
// is greater than zero and nonsignaled when its count is equal to zero
// Each time a waiting thread is released because of the semaphore's signaled
// state, the count of the semaphore is decreased by one. 
    mutex_list *ml = (mutex_list *)hsem;

    pthread_mutex_lock(ml->pm);
    if (prev_count != 0) *prev_count = ml->semaphore;
    if (ml->semaphore == 0) pthread_cond_signal(ml->pc);
    ml->semaphore += increment;
    pthread_mutex_unlock(ml->pm);

    return 1;
}


long WINAPI expRegOpenKeyExA(long key, const char* subkey, long reserved, long access, int* newkey)
{
    dbgprintf("RegOpenKeyExA(%d,%s)\n", key, subkey);
    return RegOpenKeyExA(key, subkey, reserved, access, newkey);
}    
long WINAPI expRegCloseKey(long key)
{
    dbgprintf("RegCloseKey()\n");
    return RegCloseKey(key);
}         
long WINAPI expRegQueryValueExA(long key, const char* value, int* reserved, int* type, int* data, int* count)
{
    dbgprintf("RegQueryValueExA()\n");
    return RegQueryValueExA(key, value, reserved, type, data, count);
}  
long WINAPI expRegCreateKeyExA(long key, const char* name, long reserved,
							   void* classs, long options, long security,
							   void* sec_attr, int* newkey, int* status) 
{
    dbgprintf("RegCreateKeyExA()\n");
    return RegCreateKeyExA(key, name, reserved, classs, options, security, sec_attr, newkey, status);
}
long WINAPI expRegSetValueExA(long key, const char* name, long v1, long v2, void* data, long size)
{
    dbgprintf("RegSetValueExA()\n");
    return RegSetValueExA(key, name, v1, v2, data, size);
}        

long WINAPI expRegOpenKeyA (
long hKey,
 LPCSTR lpSubKey,
 int* phkResult
){
    return  RegOpenKeyExA(hKey, lpSubKey, 0, 0, phkResult);
}

long WINAPI expQueryPerformanceCounter(long long* z)
{
    dbgprintf("QueryPerformanceCounter()\n");
    longcount(z);
    return 1; 
}

static double old_freq()
{
    static double ofreq=0.0;
    int i;
    int x,y;
    i=time(NULL);
    if (ofreq != 0.0) return ofreq;
    while(i==time(NULL));
    x=localcount();
    i++;
    while(i==time(NULL));
    y=localcount();
    ofreq = (double)(y-x)/1000.;
    return ofreq;
}
static double CPU_Freq()
{
//#ifdef USE_TSC
	FILE *f = fopen ("/proc/cpuinfo", "r");
	char line[200];
	char model[200]="unknown";
	char flags[500]="";
	char	*s,*value;
	double freq=-1;
	
	if (!f)
	{
	    //printf("Can't open /proc/cpuinfo for reading\n");
	    return old_freq();
	}    
	while (fgets(line,200,f)!=NULL) 
	{
		/* NOTE: the ':' is the only character we can rely on */
		if (!(value = strchr(line,':')))
			continue;
		/* terminate the valuename */
		*value++ = '\0';
		/* skip any leading spaces */
		while (*value==' ') value++;
		if ((s=strchr(value,'\n')))
			*s='\0';

		if (!strncasecmp(line, "cpu MHz",strlen("cpu MHz"))) 
		{
		    sscanf(value, "%lf", &freq);
		    freq*=1000;
		    break;
		}
		continue;
		
	}
	fclose(f);
	if(freq<0)return old_freq();
	return freq;
//#else
//	return old_freq();
//#endif    	
}

long WINAPI expQueryPerformanceFrequency(long long* z)
{
    dbgprintf("QueryPerformanceFrequency()\n");
    *z=(long long)CPU_Freq();
    return 1; 
}
long WINAPI exptimeGetTime()
{
    struct timeval t;
    dbgprintf("timeGetTime()\n");
    gettimeofday(&t, 0);
    return 1000*t.tv_sec+t.tv_usec/1000;
}
void* WINAPI expLocalHandle(void* v)
{
    dbgprintf("LocalHandle\n");
    return v;
}        
void* WINAPI expGlobalHandle(void* v)
{
    dbgprintf("GlobalHandle\n");
    return v;
}        
int WINAPI expGlobalUnlock(void* v)
{
    dbgprintf("GlobalUnlock\n");
    return 1;
}
//
void* WINAPI expGlobalFree(void* v)
{
    dbgprintf("GlobalFree(%X)\n", v);
    //my_release(v);
    free(v);
    return 0;
}
        
void* WINAPI expGlobalReAlloc(void* v, int size, int flags)
{
    dbgprintf("GlobalReAlloc(%X, %d, %x)\n", v,size,flags);
    return realloc(v, size);
}

int WINAPI expLocalUnlock(void* v)
{
    dbgprintf("LocalUnlock\n");
    return 1;
}
//
void* WINAPI expLocalFree(void* v)
{
    dbgprintf("LocalFree(%X)\n", v);
    my_release(v);
    return 0;
}        

HRSRC WINAPI expFindResourceA(HMODULE module, char* name, char* type)
{
    dbgprintf("FindResourceA\n");
    return FindResourceA(module, name, type);
}
HGLOBAL WINAPI expLoadResource(HMODULE module, HRSRC res)
{
    dbgprintf("LoadResource\n");
    return LoadResource(module, res);;    
}
void* WINAPI expLockResource(long res)
{
    dbgprintf("LockResource\n");
    return LockResource(res);
}    
int WINAPI expFreeResource(long res)
{
    dbgprintf("FreeResource\n");
    return FreeResource(res);
}    
//bool fun(HANDLE)
//!0 on success
int WINAPI expCloseHandle(long v1)
{
    dbgprintf("CloseHandle\n");
    return 1;
}    

const char* WINAPI expGetCommandLineA()
{
    dbgprintf("GetCommandLine\n");
    return "c:\\aviplay.exe";
}
LPWSTR WINAPI expGetEnvironmentStringsW()
{
    static short envs[]={'p', 'a', 't', 'h', ' ', 'c', ':', '\\', 0, 0};
    dbgprintf("GetEnvStringsW\n");
    return (LPWSTR)envs;
}
void * WINAPI expRtlZeroMemory(void *p, size_t len)
{
	dbgprintf("RtlZeroMemory %x len %d\n",p,len);
	return memset(p,0,len);
}
void * WINAPI expRtlMoveMemory(void *dst, void *src, size_t len)
{
	dbgprintf("RtlMoveMemory src %x dst %x len %d\n",src,dst,len);
	return memmove(dst,src,len);
}

void * WINAPI expRtlFillMemory(void *p, int ch, size_t len)
{
	dbgprintf("RtlFillMemory p %x char %x len %d\n",p,ch,len);
	return memset(p,ch,len);
}
int WINAPI expFreeEnvironmentStringsW(short* strings)
{
    dbgprintf("FreeEnvStringsW\n");
    return 1;
}
LPCSTR WINAPI expGetEnvironmentStrings()
{
    dbgprintf("GetEnvStrings\n");
    return "\0\0";
}

int WINAPI expGetStartupInfoA(STARTUPINFOA *s)
{
    int i;    
    dbgprintf("GetStartupInfoA\n");
/*    
    for(i=0; i<sizeof(STARTUPINFOA)/4; i++)
     ((int*)s)[i]=i+0x200;
*/
    memset(s, 0, sizeof(*s));
    s->cb=sizeof(*s);
    s->lpReserved="qwe";
    s->lpDesktop="rty";
    s->lpTitle="uio";
    s->dwX=s->dwY=0;
    s->dwXSize=s->dwYSize=200;
    s->dwFlags=s->wShowWindow=0;
    return 1;
}    

int WINAPI expGetStdHandle(int z)
{
    dbgprintf("GetStdHandle\n");
//    dbgprintf("WARNING: Unsupported call: GetStdHandle\n");       
    return 1234;
}
int WINAPI expGetFileType(int handle)
{
    dbgprintf("GetFileType\n");
//    dbgprintf("WARNING: Unsupported call: GetFileType\n");       
    return 5678;
}
int WINAPI expSetHandleCount(int count)
{
    dbgprintf("SetHandleCount\n");
    return 1;        
}
int WINAPI expGetACP()
{
    dbgprintf("GetACP\n");
//    dbgprintf("WARNING: Unsupported call: GetACP\n");       
    return 0; 
}
extern WINE_MODREF *MODULE32_LookupHMODULE(HMODULE m);
int WINAPI expGetModuleFileNameA(int module, char* s, int len)
{
    WINE_MODREF *mr;
    dbgprintf("GetModuleFileNameA\n");
    printf("File name of module %X requested\n", module);
    if(s==0)
    return 0;
    if(len<35)
    return 0;
    strcpy(s, "c:\\windows\\system\\");
    mr=MODULE32_LookupHMODULE(module);
    if(mr==0)//oops
    {
        strcat(s, "aviplay.dll");
	return 1;
    }	
    if(strrchr(mr->filename, '/')==NULL)
	strcat(s, mr->filename);
    else
	strcat(s, strrchr(mr->filename, '/')+1);
    return 1;
}    
    
int WINAPI expSetUnhandledExceptionFilter(void* filter)
{
    dbgprintf("SetUnhandledExcFilter\n");
    return 1;//unsupported and probably won't ever be supported
}    
extern char* def_path;

int WINAPI expLoadLibraryA(char* name)
{
    char qq[256];
    dbgprintf("LoadLibraryA\n");
    printf("They want library %s\n", name);
    strcpy(qq, def_path);
    strcat(qq, "/");
    strcat(qq, name);
    return LoadLibraryA(qq);
}      
int WINAPI expFreeLibrary(int module)
{
    dbgprintf("FreeLibrary\n");
    return FreeLibrary(module);
}   
void* WINAPI expGetProcAddress(HMODULE mod, char* name)
{
    dbgprintf("GetProcAddress\n");
    return GetProcAddress(mod, name);
}    

long WINAPI expCreateFileMappingA(int hFile, void* lpAttr,
    long flProtect, long dwMaxHigh, long dwMaxLow, const char* name)
{
    dbgprintf("CreateFileMappingA\n");
    return CreateFileMappingA(hFile, lpAttr, flProtect, dwMaxHigh, dwMaxLow, name);
}    

long WINAPI expOpenFileMappingA(long hFile, long hz, const char* name)
{
    dbgprintf("OpenFileMappingA\n");
    return OpenFileMappingA(hFile, hz, name);
}

void* WINAPI expMapViewOfFile(HANDLE file, DWORD mode, DWORD offHigh, DWORD offLow, DWORD size)
{
    dbgprintf("MapViewOfFile(%d, %x, %x, %x, %x)\n",
	file,mode,offHigh,offLow,size);
    return (char*)file+offLow;
}

void* WINAPI expUnmapViewOfFile(void* view)
{
    dbgprintf("UnmapViewOfFile()\n");
    return 0;
}

void* WINAPI expSleep(int time)
{
    dbgprintf("Sleep(%d)\n", time);
    usleep(time);
    return 0;
}
 // why does IV32 codec want to call this? I don't know ...
void* WINAPI expCreateCompatibleDC(int hdc)
{
        dbgprintf("CreateCompatibleDC(%d)\n", hdc);
        return (void*)129;
}

int WINAPI expGetDeviceCaps(int hdc, int unk)
{
        dbgprintf("GetDeviceCaps(%d, %d)\n", hdc, unk);
        return 0;
}

WIN_BOOL WINAPI expDeleteDC(int hdc)
{
        dbgprintf("DeleteDC(%d)\n", hdc);
        return 0;
}

int expwsprintfA(char* string, char* format, ...)
{
    va_list va;
    va_start(va, format);
    dbgprintf("wsprintfA\n");
    return vsprintf(string, format, va);
}

int WINAPI expGetPrivateProfileIntA(const char* appname, const char* keyname, int default_value, const char* filename)
{
    int size=255;
    char buffer[256];
    char* fullname;
    int result;
    
    buffer[255]=0;
    dbgprintf("GetPrivateProfileIntA(%s, %s, %s)\n", appname, keyname, filename );
    if(!(appname && keyname && filename) ) return default_value;
    fullname=(char*)malloc(50+strlen(appname)+strlen(keyname)+strlen(filename));
    strcpy(fullname, "Software\\IniFileMapping\\");
    strcat(fullname, appname);
    strcat(fullname, "\\");
    strcat(fullname, keyname);
    strcat(fullname, "\\");
    strcat(fullname, filename);
    result=RegQueryValueExA(HKEY_LOCAL_MACHINE, fullname, NULL, NULL, (int*)buffer, &size);
    if((size>=0)&&(size<256))
	buffer[size]=0;
//    printf("GetPrivateProfileIntA(%s, %s, %s) -> %s\n", appname, keyname, filename, buffer);
    free(fullname); 
    if(result)
    return default_value;
    else
	return atoi(buffer);    	
}
int WINAPI expGetProfileIntA(const char* appname, const char* keyname, int default_value)
{
    printf("GetProfileIntA(%s, %s, %d)\n", appname, keyname, default_value);
    return expGetPrivateProfileIntA(appname, keyname, default_value, "default");    
}

int WINAPI expGetPrivateProfileStringA(const char* appname, const char* keyname,
	const char* def_val, char* dest, unsigned int len, const char* filename)
{
    int result;
    int size;
    char* fullname;
    dbgprintf("GetPrivateProfileStringA(%s, %s, %s, %X, %X, %s)\n", appname, keyname, def_val, dest, len, filename );
    if(!(appname && keyname && filename) ) return 0;
    fullname=(char*)malloc(50+strlen(appname)+strlen(keyname)+strlen(filename));
    strcpy(fullname, "Software\\IniFileMapping\\");
    strcat(fullname, appname);
    strcat(fullname, "\\");
    strcat(fullname, keyname);
    strcat(fullname, "\\");
    strcat(fullname, filename);
    size=len;
    result=RegQueryValueExA(HKEY_LOCAL_MACHINE, fullname, NULL, NULL, (int*)dest, &size);
//    printf("GetPrivateProfileStringA(%s, %s, %s, %X, %X, %s)\n", appname, keyname, def_val, dest, len, filename );
    free(fullname); 
    if(!result)
	return size;
    strncpy(dest, def_val, size);
    if (strlen(def_val)< size) size = strlen(def_val);
    return size;
}
int WINAPI expWritePrivateProfileStringA(const char* appname, const char* keyname,
	const char* string, const char* filename)
{
    int size=256;
    char* fullname;
    dbgprintf("WritePrivateProfileStringA(%s, %s, %s, %s)\n", appname, keyname, string, filename );
    if(!(appname && keyname && filename) ) return -1;
    fullname=(char*)malloc(50+strlen(appname)+strlen(keyname)+strlen(filename));
    strcpy(fullname, "Software\\IniFileMapping\\");
    strcat(fullname, appname);
    strcat(fullname, "\\");
    strcat(fullname, keyname);
    strcat(fullname, "\\");
    strcat(fullname, filename);
    RegSetValueExA(HKEY_LOCAL_MACHINE, fullname, 0, REG_SZ, (int*)string, strlen(string));
//    printf("RegSetValueExA(%s,%d)\n", string, strlen(string));
//    printf("WritePrivateProfileStringA(%s, %s, %s, %s)\n", appname, keyname, string, filename );
    free(fullname); 
    return 0;
}

unsigned int _GetPrivateProfileIntA(const char* appname, const char* keyname, INT default_value, const char* filename)
{
    return expGetPrivateProfileIntA(appname, keyname, default_value, filename);
}
int _GetPrivateProfileStringA(const char* appname, const char* keyname,
	const char* def_val, char* dest, unsigned int len, const char* filename)
{
    return expGetPrivateProfileStringA(appname, keyname, def_val, dest, len, filename);
}
int _WritePrivateProfileStringA(const char* appname, const char* keyname,
	const char* string, const char* filename)
{
    return expWritePrivateProfileStringA(appname, keyname, string, filename);
}


int WINAPI expDefDriverProc(int _private, int id, int msg, int arg1, int arg2)
{
    printf("Called DefDriverProc(%X)\n", msg);
    return 0;
}    

int WINAPI expSizeofResource(int v1, int v2)
{
    dbgprintf("SizeofResource()\n");
    return SizeofResource(v1, v2);
}    

int WINAPI expGetLastError()
{
    dbgprintf("GetLastError()\n");
    return GetLastError();
}

void WINAPI expSetLastError(int error)
{
    dbgprintf("SetLastError()\n");
    SetLastError(error);
}        

char* expstrrchr(char* string, int value)
{
    return strrchr(string, value);
}    

char* expstrchr(char* string, int value)
{
    return strchr(string, value);
}    
int expstrlen(char* str) { return strlen(str); }
int expmemmove(void* dest, void* src, int n) {return memmove(dest, src, n);}
int expmemcmp(void* dest, void* src, int n) {return memcmp(dest, src, n);}
time_t exptime(time_t* t){return time(t);}

int WINAPI expStringFromGUID2(GUID* guid, char* str, int cbMax)
{
    return snprintf(str, cbMax, "%.8x-%.4x-%.4x-%.2x%.2x%.2x%.2x%.2x%.2x%.2x%.2x",
     guid->f1, guid->f2, guid->f3,
     guid->f4[0], guid->f4[1], guid->f4[2], guid->f4[3], 
     guid->f4[4], guid->f4[5], guid->f4[6], guid->f4[7]);
}


int WINAPI expGetFileVersionInfoSizeA(const char* name, int* lpHandle)
{
    printf("GetFileVersionInfoSizeA(%s,0x%X)\n", name, lpHandle);
    return 0;
}    

int WINAPI expIsBadStringPtrW(const short* string, int nchars)
{
    if(string==0)return 1;
    return 0;
}    
extern long WINAPI InterlockedExchangeAdd( long* dest, long incr )
{
    long ret;
    __asm__ __volatile__( "lock; xaddl %0,(%1)"
                          : "=r" (ret) : "r" (dest), "0" (incr) : "memory" );
    return ret;
}

extern long WINAPI expInterlockedIncrement( long* dest )
{
    return InterlockedExchangeAdd( dest, 1 ) + 1;
}
extern long WINAPI expInterlockedDecrement( long* dest )
{
    return InterlockedExchangeAdd( dest, -1 ) - 1;
}

extern void WINAPI expOutputDebugStringA( const char* string )
{
    fprintf(stderr, "DEBUG: %s\n", string);
}    

int WINAPI expGetDC(int hwnd)
{
    return 0;
}

int WINAPI expGetDesktopWindow()
{
    return 0;
}
     
int WINAPI expReleaseDC(int hwnd, int hdc)
{
    return 0;
}    

int WINAPI expLoadCursorA(int handle,LPCSTR name)
{
  static cursor[100];
  dbgprintf("LoadCursorA()\n");
  return (int)cursor;
}
int WINAPI expSetCursor(void *cursor)
{
	return (int)cursor;
}
int WINAPI expGetSystemPaletteEntries(int hdc, int iStartIndex, int nEntries, void* lppe)
{
    return 0;
}    
/*
typedef struct _TIME_ZONE_INFORMATION {
    long Bias;
    char StandardName[32];
    SYSTEMTIME StandardDate;
    long StandardBias;
    char DaylightName[32];
    SYSTEMTIME DaylightDate;
    long DaylightBias;
} TIME_ZONE_INFORMATION, *LPTIME_ZONE_INFORMATION;    
*/

int WINAPI expGetTimeZoneInformation(LPTIME_ZONE_INFORMATION lpTimeZoneInformation)
{
    const short std_name[]={'S', 't', 'd', ' ', 'N', 'a', 'm', 'e', 0};
    const short day_name[]={'D', 'a', 'y', ' ', 'N', 'a', 'm', 'e', 0};
    dbgprintf("GetTimeZoneInformation()\n");
    memset(lpTimeZoneInformation, 0, sizeof(TIME_ZONE_INFORMATION));
//    memcpy(lpTimeZoneInformation->StandardName, std_name, sizeof(std_name));
//    memcpy(lpTimeZoneInformation->DaylightName, day_name, sizeof(day_name));
    return TIME_ZONE_ID_STANDARD;
}    

void WINAPI expGetLocalTime(SYSTEMTIME* systime)
{
    time_t local_time;
    struct tm *local_tm;
    struct timeval tv;
    
    dbgprintf("GetLocalTime()\n");
    gettimeofday(&tv, NULL);
    local_time=tv.tv_sec;
    local_tm=localtime(&local_time);
    
    systime->wYear = local_tm->tm_year + 1900;
    systime->wMonth = local_tm->tm_mon + 1;
    systime->wDayOfWeek = local_tm->tm_wday;
    systime->wDay = local_tm->tm_mday;
    systime->wHour = local_tm->tm_hour;
    systime->wMinute = local_tm->tm_min;
    systime->wSecond = local_tm->tm_sec;
    systime->wMilliseconds = (tv.tv_usec / 1000) % 1000;
}

int WINAPI expGetSystemTime(SYSTEMTIME* systime)
{
    time_t local_time;
    struct tm *local_tm;
    struct timeval tv;
    
    dbgprintf("GetSystemTime()\n");
    gettimeofday(&tv, NULL);
    local_time=tv.tv_sec;
    local_tm=gmtime(&local_time);
    
    systime->wYear = local_tm->tm_year + 1900;
    systime->wMonth = local_tm->tm_mon + 1;
    systime->wDayOfWeek = local_tm->tm_wday;
    systime->wDay = local_tm->tm_mday;
    systime->wHour = local_tm->tm_hour;
    systime->wMinute = local_tm->tm_min;
    systime->wSecond = local_tm->tm_sec;
    systime->wMilliseconds = (tv.tv_usec / 1000) % 1000;
    
}

int WINAPI expGetEnvironmentVariableA(const char* name, char* field, int size)
{
    char *p;
    dbgprintf("GetEnvironmentVariableA [%s]\n",name);
//    printf("%s %x %x\n", name, field, size);
    if(field)field[0]=0;
/*
    p = getenv(name);
    if (p) strncpy(field,p,size);
*/
    if (strcmp(name,"__MSVCRT_HEAP_SELECT")==0)
       strcpy(field,"__GLOBAL_HEAP_SELECTED,1");
    return strlen(field);
}

void* WINAPI expCoTaskMemAlloc(ULONG cb)
{
    return my_mreq(cb, 0);
}
void WINAPI expCoTaskMemFree(void* cb)
{
    my_release(cb);
}

void* CoTaskMemAlloc(ULONG cb){return expCoTaskMemAlloc(cb);}
void CoTaskMemFree(void* cb){expCoTaskMemFree(cb);}

struct COM_OBJECT_INFO
{
    GUID clsid;
    long (*GetClassObject) (GUID* clsid, GUID* iid, void** ppv);
};

static struct COM_OBJECT_INFO* com_object_table=0;
static int com_object_size=0;
int RegisterComClass(GUID* clsid, GETCLASSOBJECT gcs)
{
    if(!clsid)return -1;
    if(!gcs)return -1;
    com_object_table=realloc(com_object_table, sizeof(struct COM_OBJECT_INFO)*(++com_object_size));
    com_object_table[com_object_size-1].clsid=*clsid;        
    com_object_table[com_object_size-1].GetClassObject=gcs;
    return 0;        
}

GUID IID_IUnknown={0x00000000, 0x0000, 0x0000,
    {0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46}};
GUID IID_IClassFactory={0x00000001, 0x0000, 0x0000,
    {0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46}};	

long WINAPI expCoCreateInstance(GUID* rclsid, struct IUnknown* pUnkOuter,
                    long dwClsContext, GUID* riid, void** ppv)
{
    int i;
    struct COM_OBJECT_INFO* ci=0;
    for(i=0; i<com_object_size; i++)
	if(!memcmp(rclsid, &com_object_table[i].clsid, sizeof(GUID)))
	    ci=&com_object_table[i];
    if(!ci)return 0x80040154;
    // in 'real' world we should mess with IClassFactory here
    i=ci->GetClassObject(rclsid, riid, ppv);
    return i;
}		    
		    
long CoCreateInstance(GUID* rclsid, struct IUnknown* pUnkOuter,
                    long dwClsContext, GUID* riid, void** ppv)
{
    return expCoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, ppv);
}

int WINAPI
 expIsRectEmpty(
CONST RECT *lprc)
{
    if(!lprc)return TRUE;
    if(lprc->right==lprc->left)return TRUE;
    if(lprc->top==lprc->bottom)return TRUE;
    return FALSE;
}

int _adjust_fdiv=0; //what's this?




unsigned int WINAPI expGetTempPathA(unsigned int len, char* path)
{
    dbgprintf("GetTempPathA(%d, 0x%x)\n", len, path);
    if(len<5)return 0;
    strcpy(path, "/tmp");
    return 5;
}
/*
FYI:
typedef struct
{
    DWORD     dwFileAttributes;
    FILETIME  ftCreationTime;
    FILETIME  ftLastAccessTime;
    FILETIME  ftLastWriteTime;
    DWORD     nFileSizeHigh;
    DWORD     nFileSizeLow;
    DWORD     dwReserved0;
    DWORD     dwReserved1;
    CHAR      cFileName[260];
    CHAR      cAlternateFileName[14];
} WIN32_FIND_DATAA, *LPWIN32_FIND_DATAA;
*/

HANDLE WINAPI expFindFirstFileA(LPCSTR s, LPWIN32_FIND_DATAA lpfd)
{
    dbgprintf("FindFirstFileA(%s)\n", s);
    return (HANDLE)-1;
}
WIN_BOOL  WINAPI expDeleteFileA(LPCSTR s)
{
    dbgprintf("DeleteFileA(%s)\n", s);
    return 0;
}
WIN_BOOL  WINAPI expFileTimeToLocalFileTime(const FILETIME* cpf, LPFILETIME pf)
{
    dbgprintf("FileTimeToLocalFileTime()\n");
    return 0;
}

UINT WINAPI expGetTempFileNameA(LPCSTR cs1,LPCSTR cs2,UINT i,LPSTR ps)
{
    char mask[16]="/tmp/AP_XXXXXX";
    int result;
    dbgprintf("GetTempFileNameA(%s, %s, %d, 0x%x)\n", cs1, cs2, i, ps);
    if(i && i<10)return -1;
    result=mkstemp(mask);
    sprintf(ps, "AP%d", result);
}
//
// This func might need proper implementation if we want AngelPotion codec.
// They try to open APmpeg4v1.apl with it.
// DLL will close opened file with CloseHandle().
//
HANDLE WINAPI expCreateFileA(LPCSTR cs1,DWORD i1,DWORD i2,
    LPSECURITY_ATTRIBUTES p1, DWORD i3,DWORD i4,HANDLE i5)
{
    dbgprintf("CreateFileA(%s, %d, %d, 0x%x, %d, %d, 0x%x)\n", cs1, i1,
	     i2, p1, i3, i4, i5);
    if(!cs1)return -1;
    if(strlen(cs1)<2)return -1;
    if(strncmp(cs1, "AP", 2))
    {
	int result;
	char* tmp=(char*)malloc(strlen(def_path)+50);
	strcpy(tmp, def_path);
	strcat(tmp, "/");
	strcat(tmp, "APmpg4v1.apl");
	result=open(tmp, O_RDONLY);
	free(tmp);
	return result;
    };
    return atoi(cs1+2); 
}
LPCSTR WINAPI expGetSystemDirectoryA() {return def_path;}
WIN_BOOL WINAPI expReadFile(HANDLE h,LPVOID pv,DWORD size,LPDWORD rd,LPOVERLAPPED unused)
{
    int result;
    dbgprintf("ReadFile(%d, 0x%x, %d -> 0x%x)\n", h, pv, size, rd);
    result=read(h, pv, size);
    if(rd)*rd=result;
    if(!result)return 0;
    return 1;
}

WIN_BOOL WINAPI expWriteFile(HANDLE h,LPCVOID pv,DWORD size,LPDWORD wr,LPOVERLAPPED unused)
{
    int result;
    dbgprintf("WriteFile(%d, 0x%x, %d -> 0x%x)\n", h, pv, size, wr);
    result=write(h, pv, size);
    if(wr)*wr=result;
    if(!result)return 0;
    return 1;
}
DWORD  WINAPI expSetFilePointer(HANDLE h, LONG val, LPLONG ext, DWORD whence)
{
    int wh;
    dbgprintf("SetFilePointer(%d, %d, 0x%x, %d)\n", h, val, ext, whence);
//why would DLL want temporary file with >2Gb size?
    switch(whence)
    {
    case FILE_BEGIN:
	wh=SEEK_SET;break;
    case FILE_END:
	wh=SEEK_END;break;
    case FILE_CURRENT:
	wh=SEEK_CUR;break;
    default:
	return -1;
    }
    return lseek(h, val, wh);
}

HDRVR WINAPI expOpenDriverA(LPCSTR szDriverName, LPCSTR szSectionName,
                             LPARAM lParam2)
{
    dbgprintf("OpenDriverA(%s, %s, 0x%x)\n", szDriverName, szSectionName, lParam2);
    return -1;    
}
HDRVR WINAPI expOpenDriver(LPCSTR szDriverName, LPCSTR szSectionName,
                             LPARAM lParam2)
{
    dbgprintf("OpenDriver(%s, %s, 0x%x)\n", szDriverName, szSectionName, lParam2);
    return -1;    
}














struct exports
{
    char name[64];
    int id;
    void* func;
};
struct libs 
{
    char name[64];
    int length;
    struct exports* exps;
};

#define FF(X,Y) \
{#X, Y, (void*)exp##X},

struct exports exp_kernel32[]={
FF(IsBadWritePtr, 357)
FF(IsBadReadPtr, 354)
FF(IsBadStringPtrW, -1)
FF(DisableThreadLibraryCalls, -1)
FF(CreateThread, -1)
FF(CreateEventA, -1)
FF(SetEvent, -1)
FF(ResetEvent, -1)
FF(WaitForSingleObject, -1)
FF(GetSystemInfo, -1)
FF(GetVersion, 332)
FF(HeapCreate, 461)
FF(HeapAlloc, -1)
FF(HeapDestroy, -1)
FF(HeapFree, -1)
FF(HeapSize, -1)
FF(GetProcessHeap, -1)
FF(VirtualAlloc, -1)
FF(VirtualFree, -1)
FF(InitializeCriticalSection, -1) 
FF(EnterCriticalSection, -1)
FF(LeaveCriticalSection, -1) 
FF(DeleteCriticalSection, -1)
FF(TlsAlloc, -1)
FF(TlsFree, -1)
FF(TlsGetValue, -1)
FF(TlsSetValue, -1)
FF(GetCurrentThreadId, -1)
FF(LocalAlloc, -1) 
FF(LocalLock, -1)
FF(GlobalAlloc, -1)
FF(GlobalReAlloc, -1)
FF(GlobalLock, -1)
FF(MultiByteToWideChar, 427)
FF(WideCharToMultiByte, -1)
FF(GetVersionExA, -1)
FF(CreateSemaphoreA, -1)
FF(QueryPerformanceCounter, -1)
FF(QueryPerformanceFrequency, -1)
FF(LocalHandle, -1)
FF(LocalUnlock, -1)
FF(LocalFree, -1)
FF(GlobalHandle, -1)
FF(GlobalUnlock, -1)
FF(GlobalFree, -1)
FF(LoadResource, -1)
FF(ReleaseSemaphore, -1) 
FF(FindResourceA, -1)
FF(LockResource, -1)
FF(FreeResource, -1)
FF(SizeofResource, -1)
FF(CloseHandle, -1)
FF(GetCommandLineA, -1)
FF(GetEnvironmentStringsW, -1)
FF(FreeEnvironmentStringsW, -1)
FF(GetEnvironmentStrings, -1)  
FF(GetStartupInfoA, -1)
FF(GetStdHandle, -1)
FF(GetFileType, -1)
FF(SetHandleCount, -1)
FF(GetACP, -1)
FF(GetModuleFileNameA, -1)
FF(SetUnhandledExceptionFilter, -1)
FF(LoadLibraryA, -1)
FF(GetProcAddress, -1)
FF(FreeLibrary, -1)
FF(CreateFileMappingA, -1)
FF(OpenFileMappingA, -1)
FF(MapViewOfFile, -1)
FF(UnmapViewOfFile, -1)
FF(Sleep, -1)
FF(GetModuleHandleA, -1)
FF(GetProfileIntA, -1)
FF(GetPrivateProfileIntA, -1)
FF(GetPrivateProfileStringA, -1)
FF(WritePrivateProfileStringA, -1)
FF(GetLastError, -1)
FF(SetLastError, -1)
FF(InterlockedIncrement, -1)
FF(InterlockedDecrement, -1)
FF(GetTimeZoneInformation, -1)
FF(OutputDebugStringA, -1)
FF(GetLocalTime, -1)
FF(GetSystemTime, -1)
FF(GetEnvironmentVariableA, -1)
FF(RtlZeroMemory,-1)
FF(RtlMoveMemory,-1)
FF(RtlFillMemory,-1)
FF(GetTempPathA,-1)
FF(FindFirstFileA,-1)
FF(FileTimeToLocalFileTime,-1)
FF(DeleteFileA,-1)
FF(ReadFile,-1)
FF(WriteFile,-1)
FF(SetFilePointer,-1)
FF(GetTempFileNameA,-1)
FF(CreateFileA,-1)
FF(GetSystemDirectoryA,-1)
};

struct exports exp_msvcrt[]={
FF(malloc, -1)
FF(_initterm, -1)
FF(free, -1)
{"??3@YAXPAX@Z", -1, expdelete},
{"??2@YAPAXI@Z", -1, expnew},
{"_adjust_fdiv", -1, (void*)&_adjust_fdiv},
FF(strrchr, -1)
FF(strchr, -1)
FF(strlen, -1)
FF(memmove, -1)
FF(memcmp, -1)
FF(time, -1)
};
struct exports exp_winmm[]={
FF(GetDriverModuleHandle, -1)
FF(timeGetTime, -1)
FF(DefDriverProc, -1)
FF(OpenDriverA, -1)
FF(OpenDriver, -1)
};
struct exports exp_user32[]={
FF(LoadStringA, -1)
FF(wsprintfA, -1)
FF(GetDC, -1)
FF(GetDesktopWindow, -1)
FF(ReleaseDC, -1)
FF(IsRectEmpty, -1)
FF(LoadCursorA,-1)
FF(SetCursor,-1)
};
struct exports exp_advapi32[]={
FF(RegOpenKeyA, -1)
FF(RegOpenKeyExA, -1)
FF(RegCreateKeyExA, -1)
FF(RegQueryValueExA, -1)
FF(RegSetValueExA, -1)
FF(RegCloseKey, -1)
};
struct exports exp_gdi32[]={
FF(CreateCompatibleDC, -1)
FF(GetDeviceCaps, -1)
FF(DeleteDC, -1)
FF(GetSystemPaletteEntries, -1)
};
struct exports exp_version[]={
FF(GetFileVersionInfoSizeA, -1)
};
struct exports exp_ole32[]={
FF(CoTaskMemAlloc, -1)
FF(CoTaskMemFree, -1)
FF(CoCreateInstance, -1)
FF(StringFromGUID2, -1)
};
#define LL(X) \
{#X".dll", sizeof(exp_##X)/sizeof(struct exports), exp_##X},

struct libs libraries[]={
LL(kernel32)
LL(msvcrt)
LL(winmm)
LL(user32)
LL(advapi32)
LL(gdi32)
LL(version)
LL(ole32)
};

void* LookupExternal(const char* library, int ordinal)
{
    char* answ;
    int i,j;
    if(library==0)
    {
	printf("ERROR: library=0\n");
	return (void*)ext_unknown;
    }
    printf("External func %s:%d\n", library, ordinal);
//    printf("%x %x\n", &unk_exp1, &unk_exp2);

    for(i=0; i<sizeof(libraries)/sizeof(struct libs); i++)
    {
	if(strcasecmp(library, libraries[i].name))
	    continue;
	for(j=0; j<libraries[i].length; j++)
	{
	    if(ordinal!=libraries[i].exps[j].id)
		continue;
	    printf("Hit: 0x%08X\n", libraries[i].exps[j].func);
	    return libraries[i].exps[j].func;
	}
    }
    if(pos>150)return 0;
    answ=(char*)extcode+pos*0x64;
    memcpy(answ, &unk_exp1, 0x64);
    *(int*)(answ+9)=pos;
    *(int*)(answ+47)-=((int)answ-(int)&unk_exp1);
    sprintf(export_names[pos], "%s:%d", library, ordinal);
    pos++;    
    return (void*)answ;
}    

void* LookupExternalByName(const char* library, const char* name)
{
    char* answ;
    int i,j;
//   return (void*)ext_unknown;
    if(library==0)
    {
	printf("ERROR: library=0\n");
	return (void*)ext_unknown;
    }
    if(name==0)
    {
	printf("ERROR: name=0\n");
	return (void*)ext_unknown;
    }
//    printf("External func %s:%s\n", library, name);
    for(i=0; i<sizeof(libraries)/sizeof(struct libs); i++)
    {
	if(strcasecmp(library, libraries[i].name))
	    continue;
	for(j=0; j<libraries[i].length; j++)
	{
	    if(strcmp(name, libraries[i].exps[j].name))
		continue;
//	    printf("Hit: 0x%08X\n", libraries[i].exps[j].func);
	    return libraries[i].exps[j].func;
	}
    }
//    printf("%s %s\n", library, name);
    if(pos>150)return 0;
    strcpy(export_names[pos], name);
    answ=(char*)extcode+pos*0x64;
    memcpy(answ, &unk_exp1, 0x64);
    *(int*)(answ+9)=pos;
    *(int*)(answ+47)-=((int)answ-(int)&unk_exp1);
    pos++;
    return (void*)answ;
//    memcpy(extcode, &unk_exp1, 0x64);
//    *(int*)(extcode+52)-=((int)extcode-(int)&unk_exp1);
//    return (void*)extcode;
//    printf("Unknown func %s:%s\n", library, name);
//    return (void*)ext_unknown;
}

