/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_event_ksym_h
#define INC_libxmm_event_ksym_h

#ifdef __cplusplus
extern "C"
{
#endif

/** @defgroup XMM_KEYSYM_ Key symbols
 *
 * Key symbols
 *
 * @{
 */

#define	XMM_KEYSYM_SPACE		32	/**< ' ' */
#define	XMM_KEYSYM_EXCLAIM		33	/**< '!' */
#define	XMM_KEYSYM_QUOTEDBL		34	/**< '"' */
#define	XMM_KEYSYM_HASH			35	/**< '#' */
#define	XMM_KEYSYM_DOLLAR		36	/**< '$' */
#define	XMM_KEYSYM_PERCENT		37	/**< '%' */
#define	XMM_KEYSYM_AMPERSAND		38	/**< '&' */
#define	XMM_KEYSYM_QUOTE		39	/**< ''' */
#define	XMM_KEYSYM_LEFTPAREN		40	/**< '(' */
#define	XMM_KEYSYM_RIGHTPAREN		41	/**< ')' */
#define	XMM_KEYSYM_ASTERISK		42	/**< '*' */
#define	XMM_KEYSYM_PLUS			43	/**< '+' */
#define	XMM_KEYSYM_COMMA		44	/**< ',' */
#define	XMM_KEYSYM_MINUS		45	/**< '-' */
#define	XMM_KEYSYM_PERIOD		46	/**< '.' */
#define	XMM_KEYSYM_SLASH		47	/**< '/' */
#define	XMM_KEYSYM_0			48	/**< '0' */
#define	XMM_KEYSYM_1			49	/**< '1' */
#define	XMM_KEYSYM_2			50	/**< '2' */
#define	XMM_KEYSYM_3			51	/**< '3' */
#define	XMM_KEYSYM_4			52	/**< '4' */
#define	XMM_KEYSYM_5			53	/**< '5' */
#define	XMM_KEYSYM_6			54	/**< '6' */
#define	XMM_KEYSYM_7			55	/**< '7' */
#define	XMM_KEYSYM_8			56	/**< '8' */
#define	XMM_KEYSYM_9			57	/**< '9' */
#define	XMM_KEYSYM_COLON		58	/**< ':' */
#define	XMM_KEYSYM_SEMICOLON		59	/**< ';' */
#define	XMM_KEYSYM_LESS			60	/**< '<' */
#define	XMM_KEYSYM_EQUALS		61	/**< '=' */
#define	XMM_KEYSYM_GREATER		62	/**< '>' */
#define	XMM_KEYSYM_QUESTION		63	/**< '?' */
#define	XMM_KEYSYM_AT			64	/**< '@' */
#define	XMM_KEYSYM_A			65	/**< 'A' */
#define	XMM_KEYSYM_B			66	/**< 'B' */
#define	XMM_KEYSYM_C			67	/**< 'C' */
#define	XMM_KEYSYM_D			68	/**< 'D' */
#define	XMM_KEYSYM_E			69	/**< 'E' */
#define	XMM_KEYSYM_F			70	/**< 'F' */
#define	XMM_KEYSYM_G			71	/**< 'G' */
#define	XMM_KEYSYM_H			72	/**< 'H' */
#define	XMM_KEYSYM_I			73	/**< 'I' */
#define	XMM_KEYSYM_J			74	/**< 'J' */
#define	XMM_KEYSYM_K			75	/**< 'K' */
#define	XMM_KEYSYM_L			76	/**< 'L' */
#define	XMM_KEYSYM_M			77	/**< 'M' */
#define	XMM_KEYSYM_N			78	/**< 'N' */
#define	XMM_KEYSYM_O			79	/**< 'O' */
#define	XMM_KEYSYM_P			80	/**< 'P' */
#define	XMM_KEYSYM_Q			81	/**< 'Q' */
#define	XMM_KEYSYM_R			82	/**< 'R' */
#define	XMM_KEYSYM_S			83	/**< 'S' */
#define	XMM_KEYSYM_T			84	/**< 'T' */
#define	XMM_KEYSYM_U			85	/**< 'U' */
#define	XMM_KEYSYM_V			86	/**< 'V' */
#define	XMM_KEYSYM_W			87	/**< 'W' */
#define	XMM_KEYSYM_X			88	/**< 'X' */
#define	XMM_KEYSYM_Y			89	/**< 'Y' */
#define	XMM_KEYSYM_Z			90	/**< 'Z' */
#define	XMM_KEYSYM_LEFTBRACKET		91	/**< '[' */
#define	XMM_KEYSYM_BACKSLASH		92	/**< '\' */
#define	XMM_KEYSYM_RIGHTBRACKET		93	/**< ']' */
#define	XMM_KEYSYM_CARET		94	/**< '^' */
#define	XMM_KEYSYM_UNDERSCORE		95	/**< '_' */
#define	XMM_KEYSYM_BACKQUOTE		96	/**< '`' */
#define	XMM_KEYSYM_a			97	/**< 'a' */
#define	XMM_KEYSYM_b			98	/**< 'b' */
#define	XMM_KEYSYM_c			99	/**< 'c' */
#define	XMM_KEYSYM_d			100	/**< 'd' */
#define	XMM_KEYSYM_e			101	/**< 'e' */
#define	XMM_KEYSYM_f			102	/**< 'f' */
#define	XMM_KEYSYM_g			103	/**< 'g' */
#define	XMM_KEYSYM_h			104	/**< 'h' */
#define	XMM_KEYSYM_i			105	/**< 'i' */
#define	XMM_KEYSYM_j			106	/**< 'j' */
#define	XMM_KEYSYM_k			107	/**< 'k' */
#define	XMM_KEYSYM_l			108	/**< 'l' */
#define	XMM_KEYSYM_m			109	/**< 'm' */
#define	XMM_KEYSYM_n			110	/**< 'n' */
#define	XMM_KEYSYM_o			111	/**< 'o' */
#define	XMM_KEYSYM_p			112	/**< 'p' */
#define	XMM_KEYSYM_q			113	/**< 'q' */
#define	XMM_KEYSYM_r			114	/**< 'r' */
#define	XMM_KEYSYM_s			115	/**< 's' */
#define	XMM_KEYSYM_t			116	/**< 't' */
#define	XMM_KEYSYM_u			117	/**< 'u' */
#define	XMM_KEYSYM_v			118	/**< 'v' */
#define	XMM_KEYSYM_w			119	/**< 'w' */
#define	XMM_KEYSYM_x			120	/**< 'x' */
#define	XMM_KEYSYM_y			121	/**< 'y' */
#define	XMM_KEYSYM_z			122	/**< 'z' */
#define	XMM_KEYSYM_LEFTBRACE		123	/**< '{' */
#define	XMM_KEYSYM_BAR			124	/**< '|' */
#define	XMM_KEYSYM_RIGHTBRACE		125	/**< '}' */
#define	XMM_KEYSYM_TILDE		126	/**< '~' */

/*
 * Special (Control) keys
 */

#define	XMM_KEYSYM_BACKSPACE		8
#define	XMM_KEYSYM_TAB			9
#define	XMM_KEYSYM_ENTER		13
#define	XMM_KEYSYM_DELETE		14
#define	XMM_KEYSYM_F1			15
#define	XMM_KEYSYM_F2			16
#define	XMM_KEYSYM_F3			17
#define	XMM_KEYSYM_F4			18
#define	XMM_KEYSYM_F5			19
#define	XMM_KEYSYM_F6			20
#define	XMM_KEYSYM_F7			21
#define	XMM_KEYSYM_F8			22
#define	XMM_KEYSYM_F9			23
#define	XMM_KEYSYM_F10			24
#define	XMM_KEYSYM_F11			25
#define	XMM_KEYSYM_F12			26
#define	XMM_KEYSYM_ESCAPE		27
#define	XMM_KEYSYM_UP			28
#define	XMM_KEYSYM_DOWN			29
#define	XMM_KEYSYM_LEFT			30
#define	XMM_KEYSYM_RIGHT		31

/*
 * Modificator keys
 */

#define	XMM_KEYSYM_MASK_MOD		0x0110

#define	XMM_KEYSYM_LSHIFT		0x0110
#define	XMM_KEYSYM_RSHIFT		0x0111
#define	XMM_KEYSYM_LCTRL		0x0112
#define	XMM_KEYSYM_RCTRL		0x0113
#define	XMM_KEYSYM_LALT			0x0114
#define	XMM_KEYSYM_RALT			0x0115
#define	XMM_KEYSYM_LMETA		0x0116
#define	XMM_KEYSYM_RMETA		0x0117
#define	XMM_KEYSYM_NUM			0x0118
#define	XMM_KEYSYM_CAPS			0x0119
#define	XMM_KEYSYM_SCROLL		0x011A

/** @} */
/** @defgroup XMM_KEY_ Key states
 *
 * Key states
 *
 * @{
 */

	/** Key pressed. Keyboard event: A key was pressed. */
#define	XMM_KEY_PRESSED			0x0001
	/** Key released. Keyboard event: A key was released. */
#define	XMM_KEY_RELEASED		0x0002

/** @} */
/** @defgroup XMM_KEYMOD_ Key modifier
 *
 * Key modifier
 *
 * @{
 */

	/** Left Shift is down */
#define	XMM_KEYMOD_LSHIFT		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_LSHIFT )
	/** Right Shift is down */
#define	XMM_KEYMOD_RSHIFT		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_RSHIFT )
	/** A Shift key is down */
#define XMM_KEYMOD_SHIFT		( XMM_KEYMOD_LSHIFT | XMM_KEYMOD_RSHIFT )

	/** Left Control is down */
#define	XMM_KEYMOD_LCTRL		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_LCTRL )
	/** Right Control is down */
#define	XMM_KEYMOD_RCTRL		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_RCTRL )
	/** A Control key is down */
#define XMM_KEYMOD_CTRL			( XMM_KEYMOD_LCTRL | XMM_KEYMOD_RCTRL )

	/** Left Alt is down */
#define	XMM_KEYMOD_LALT			XMM_KEYSYM2KEYMOD( XMM_KEYSYM_LALT )
	/** Right Alt is down */
#define	XMM_KEYMOD_RALT			XMM_KEYSYM2KEYMOD( XMM_KEYSYM_RALT )
	/** An Alt key is down */
#define XMM_KEYMOD_ALT			( XMM_KEYMOD_LALT | XMM_KEYMOD_RALT )

	/** Numlock is down */
#define	XMM_KEYMOD_NUM			XMM_KEYSYM2KEYMOD( XMM_KEYSYM_NUM )
	/** Capslock is down */
#define	XMM_KEYMOD_CAPS			XMM_KEYSYM2KEYMOD( XMM_KEYSYM_CAPS )
	/** Scrolllock is down */
#define	XMM_KEYMOD_SCROLL		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_SCROLL )

	/** NOT used */
#define	XMM_KEYMOD_LMETA		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_LMETA )
	/** NOT used */
#define	XMM_KEYMOD_RMETA		XMM_KEYSYM2KEYMOD( XMM_KEYSYM_RMETA )
	/** NOT used */
#define XMM_KEYMOD_META			( XMM_KEYMOD_LMETA | XMM_KEYMOD_RMETA )

/** @} */

	/** Convert a key symbol to key modifier flag. */
#define	XMM_KEYSYM2KEYMOD(sym)		( 1 << ( sym - XMM_KEYSYM_MASK_MOD ))

#ifdef __cplusplus
}
#endif

#endif
