/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_lpoutput_h
#define INC_libxmm_lpoutput_h

/** @file lpoutput.h
 * Linux MultiMedia Project API: Output Layer ( Plugin )
 *
 * An output plugin is only a container for a graph plugin and a sound plugin.
 */

#include <libxmm/plugin.h>
#include <libxmm/lpsound.h>
#include <libxmm/lpgraph.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Output Plugin.
 * This structure / type represents an output.
 */

typedef struct xmm_PluginOutput_s	XMM_PluginOutput;

struct xmm_PluginOutput_s
{
    /**
     * Plugin data.
     * Plugin data. Common to all XMM plugin(types)
     */
    XMM_Plugin				sys;

    /**
     * Graph output.
     * Plugin struct for graph output.
     */
    XMM_PluginGraph			graph;

    /**
     * Sound output.
     * Plugin struct for sound output.
     */
    XMM_PluginSound			sound;
};

#ifdef __cplusplus
}
#endif

#endif
