/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_list_h
#define INC_libxmm_util_list_h

/** @file list.h
 * Linux MultiMedia Project: support for lists
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Types
 */

/**
 * List type.
 * This struct is a list node and the list itself.
 */

typedef struct XMM_List_s XMM_List;

struct XMM_List_s
{
    /** Pointer to data */
    void			*data;
    /** Pointer to next node, NULL if last */
    XMM_List			*next;
    /** Pointer to previous node, NULL if first */
    XMM_List			*prev;
};

/*
 * Prototypes
 */

	/**
	 * Append item.
	 * Append some data ( one buffer/pointer ) to list.
	 *
	 * \param list pointer to a list
	 * \param data pointer to data for new items
	 *
	 * \return Upon successful completion pointer to the new
	 * first item is returned. Otherwise NULL.
	 */
XMM_List	*xmmList_Append( XMM_List *list, void *data );

	/**
	 * Remove item from list.
	 * Search for a data pointer equal to key and remove it from list.
	 *
	 * \param list pointer to a list
	 * \param key data pointer
	 *
	 * \return Upon successful completion pointer to the new
	 * first item is returned. Otherwise NULL.
	 */
XMM_List	*xmmList_Remove( XMM_List *list, void *key );

	/**
	 * Free list.
	 * Remove all items from list
	 *
	 * \param list pointer to a list
	 */
void		xmmList_Free( XMM_List *list );

#ifdef __cplusplus
}
#endif

#endif
