/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_mm_accel_h
#define INC_libxmm_util_mm_accel_h

/** @file lpsound.h
 * Linux MultiMedia Project: (Hardware) multimedia extension support
 */

#include <inttypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

/** @defgroup XMM_MMACCEL_X86_ Multimedia extensions
 *
 * Multimedia extensions
 *
 * @{
 */

	/** Intel MMX and compatible. */
#define XMM_MMACCEL_X86_MMX		0x00000001
	/** Cyrix extended MMX. */
#define XMM_MMACCEL_X86_XMMX		0x00000002
	/** AMD 3DNOW. */
#define XMM_MMACCEL_X86_3DNOW		0x00000004
	/** Intel Pentium III SSE. */
#define XMM_MMACCEL_X86_SSE		0x00000008
	/** Intel Pentium IV SSE 2. */
#define XMM_MMACCEL_X86_SSE2		0x00000010
	/** Floating Point Unit. */
#define XMM_MMACCEL_X86_FPU		0x00000020
	/** Time stamp counter */
#define	XMM_MMACCEL_X86_TSC		0x00000040

/** @} */

	/** Bits containing CPU info */
#define	XMM_MMACCEL_CPUMASK		0xF0000000
	/** Shift for CPU info */
#define	XMM_MMACCEL_CPUSHIFT		28


/** @defgroup XMM_MMACCEL_CPU CPUs
 *
 * CPUs
 *
 * @{
 */

	/** Pentium ( and clones ) */
#define	XMM_MMACCEL_CPU_586		( 5 << XMM_MMACCEL_CPUSHIFT )
	/** Pentium ( and clones ) */
#define	XMM_MMACCEL_CPU_P1		XMM_MMACCEL_i586
	/* Pentium II ( and clones ) */
#define	XMM_MMACCEL_CPU_686		( 6 << XMM_MMACCEL_CPUSHIFT )
	/* Pentium II ( and clones ) */
#define	XMM_MMACCEL_CPU_P2		XMM_MMACCEL_i686

/** @} */

/*
 * Prototypes
 */

		/**
		 * Query multimedia support.
		 * Get supported multimedia extensions
		 *
		 * \return uint32_t containing flags from the #XMM_MMACCEL_X86_ group.
		 */
uint32_t	xmmCPU_mmsupport( void );

		/**
		 * Enable / Disable extensions.
		 * You can use this call to disable extensions.
		 *
		 * \param flags flags from the #XMM_MMACCEL_X86_ group.
		 */
void		xmmCPU_mmenable( uint32_t flags );

		/**
		 * Query enabled extensions.
		 * Get enabled ( and present ) extensions.
		 *
		 * \return uint32_t containing flags from the #XMM_MMACCEL_X86_ group.
		 */
uint32_t	xmmCPU_mmenabled( void );

		/**
		 * CPU clock speed.
		 * Get clock frequency of CPU ( in Hz ).
		 *
		 * \return CPU frequency
		 */
uint32_t	xmmCPU_clockfreq( void );

#ifdef __cplusplus
}
#endif

#endif
