/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_timer_h
#define INC_libxmm_util_timer_h

/** @file timer.h
 * Linux MultiMedia Project: Timer
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Types
 */

	/**
	 * Timerproc.
	 * Type for a timer handler.
	 */
typedef int (*XMM_TimerProc)( void *priv );

/*
 * Prototypes
 */

	/**
	 * Initialize timer.
	 * Used to initialize timer system.
	 *
	 * \param interval timer interval in milliseconds
	 *
	 * \return Upon successful completion #XMM_RET_OK is returned.
	 * Otherwise an error code ( negative value ).
	 *
	 * \note This function must not be called by any application.
	 * The timer system is initialized when initializing the library.
	 */
int	xmmTimer_Init( int interval );

	/**
	 * Deinitialize timer.
	 * Used to deinitialize timer system.
	 *
	 * \note This function must not be called by any application.
	 * The timer system is deinitialized when deinitializing the library.
	 */
void	xmmTimer_Exit( void );

	/**
	 * Add timer.
	 * Used to add a handler.
	 *
	 * \param Handler handler, this will be called in the given interval
	 * \param priv pointer, which will be passed a argument to the handler
	 *
	 * \return Upon successful completion the timer ID is returned.
	 * Otherwise an error code ( negative value ).
	 */
int	xmmTimer_Add( XMM_TimerProc Handler, void *priv );

	/**
	 * Remove timer.
	 * Used to remove a handler from the handler list.
	 *
	 * \param timer timer ID of the handler, that should be removed.
	 */
void	xmmTimer_Remove( int timer );

	/**
	 * Remove all timers.
	 * Used to remove all handlers from the handler list.
	 */
void	xmmTimer_RemoveAll( void );

#ifdef __cplusplus
}
#endif

#endif
