/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_utils_h
#define INC_libxmm_util_utils_h

/** @file utils.h
 * Linux MultiMedia Project: some misc functions
 */

#include <inttypes.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C"
{
#endif

	/** Build path relative to home dir, if filename not absolute */
char	*xmm_gethome_filename( char *filename );

	/** Do some logging depending on level */
void	xmm_logging( int level, char *format, ... );

	/** Like strdup */
void	*xmm_memdup( void *source, int size );

	/** Like strdup, dupes size bytes, allocates ( size + extra ) bytes */
void	*xmm_memdup_x( void *source, int size, int extra );

	/** Create string from FOURCC */
char	*xmm_FOURCC_string( uint32_t val );

	/** Macro used to get information about the position it was used */
#define	SOURCE_INFO { printf( "DEBUG %s: line %i fuction %s()\n", \
			__FILE__, __LINE__, __FUNCTION__ ); \
			fflush( stdout ); }


#ifdef __cplusplus
}
#endif

#endif
