/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_version_h
#define INC_libxmm_version_h

/** @file version.h
 * Linux MultiMedia Project: project version
 */

#include <inttypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

/** @defgroup XMM_VERSION Version definitions
 *
 * Version definitions
 *
 * @{
 */

	/** Major version */
#define	XMM_VERSION_MAJOR		0
	/** Minor version */
#define	XMM_VERSION_MINOR		6
	/** Micro version */
#define	XMM_VERSION_MICRO		0
	/** Patch level ( positiv ) / Prerelease number ( negative ) */
#define	XMM_VERSION_PATCH		0

	/** Version string */
#define	XMM_VERSION_STRING		"0.6.0"
	/** Version value */
#define	XMM_VERSION_NUM			(( XMM_VERSION_MAJOR << 24 ) | \
					( XMM_VERSION_MINOR << 16 ) | \
					( XMM_VERSION_MICRO << 8 ) | \
					((uint8_t) XMM_VERSION_PATCH ))

/** @} */
/** @defgroup XMM_VERSION_GET Version
 *
 * Get version values from an version number
 *
 * @{
 */

	/** Get major part of the version value */
#define	XMM_VERSION_GETMAJOR(v)		(((v) >> 24) & 0xFF )
	/** Get major part of the version value */
#define	XMM_VERSION_GETMINOR(v)		(((v) >> 16 ) & 0xFF )
	/** Get major part of the version value */
#define	XMM_VERSION_GETMICRO(v)		(((v) >> 8 ) & 0xFF )
	/** Get patch part of the version value, negative value indicates prerelease */
#define	XMM_VERSION_GETPATCH(v)		((int8_t)((v) & 0xFF ))

/** @} */

/*
 * Prototypes
 */

		/** Get the version string and (number) of the (linked) library */
const char	*xmm_GetVersion( unsigned long *number );

#ifdef __cplusplus
}
#endif

#endif
