/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_xmmp_h
#define INC_libxmm_xmmp_h

/** @file xmmp.h
 * Linux MultiMedia Project - Basic definitions
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * General definitions
 */

	/** Project name ( full ) */
#define	XMM_PROJECT_NAME		"LinuX MultiMedia Project"
	/** Project name ( ID ) */
#define	XMM_PROJECT_SHORT		"XMMP"
	/** Copyright string */
#define	XMM_PROJECT_COPY		"Copyright (c) 2000, 2001 by Arthur Kleer"
	/** Used to identify XMMP plugins */
#define	XMM_PLUGIN_ID			"XMMP"
	/** Maximum path len */
#define	XMM_MAXPATHLEN			256

/** @defgroup XMM_PLUGIN_TYPE_ Plugin types
 *
 * Plugin types
 *
 * @{
 */

	/** Input plugin */
#define	XMM_PLUGIN_TYPE_INPUT		0x0100
	/** Output plugin */
#define	XMM_PLUGIN_TYPE_OUTPUT		0x0200
	/** Graph plugin */
#define	XMM_PLUGIN_TYPE_GRAPH		0x0201
	/** Sound plugin */
#define	XMM_PLUGIN_TYPE_SOUND		0x0202
	/** Codec plugin */
#define	XMM_PLUGIN_TYPE_CODEC		0x0400
	/** Video codec plugin */
#define	XMM_PLUGIN_TYPE_VCODEC		0x0401
	/** Audio codec plugin */
#define	XMM_PLUGIN_TYPE_ACODEC		0x0402
	/** Video filter plugin */
#define	XMM_PLUGIN_TYPE_VFILTER		0x0801
	/** Audio filter plugin */
#define	XMM_PLUGIN_TYPE_AFILTER		0x0802
	/** I/O plugin ( file, http, dvd, ... ) */
#define	XMM_PLUGIN_TYPE_IO		0x1000

/** @} */
/** @defgroup XMM_RET_ Return codes
 *
 * Return codes
 *
 * @{
 */

	/** Done, without error. */
#define	XMM_RET_OK			0
	/** Unspecified error */
#define	XMM_RET_ERROR			-1
	/** Not supported */
#define	XMM_RET_NOTSUPPORTED		-2
	/** End of stream */
#define	XMM_RET_EOS			-3
	/** Needs more data */
#define	XMM_RET_MOREDATA		-4
	/** Invalid argument */
#define	XMM_RET_INVALID_ARG		-5

/** @} */

#ifdef __cplusplus
}
#endif

#endif
