/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * error.c
 * Error handling
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "libxmm/error.h"
#include "../xmmpriv.h"
#include "error.h"

#include "libxmm/util/utils.h"

/*
 * Set error
 */
int xmm_SetError( void *_xmm, int error, const char *format,... )
{
  XMM		*xmm = (XMM *) _xmm;
  va_list	ap;

  if( xmm == NULL )	return -error;

  xmm->Errno = error;

  if( xmm_error_string[xmm->Errno] )
  {
	sprintf( xmm->ErrDesc, "ERROR #%i (%s)", error, xmm_error_string[error] );
	if( format[0] != '\0' )	strcat( xmm->ErrDesc, ":\n" );
  }
  else	sprintf( xmm->ErrDesc, "ERROR #%i ", error );

  va_start( ap, format );
  vsprintf( xmm->ErrDesc + strlen( xmm->ErrDesc ), format, ap );
  va_end( ap );

  return -error;
}

/*
 * Get error code.
 */
int xmm_Error( void *_xmm )
{
  XMM	*xmm = (XMM *) _xmm;

  return xmm->Errno;
}

/*
 * Get error string.
 */
const char *xmm_ErrorString( void *_xmm )
{
  XMM	*xmm = (XMM *) _xmm;

  return xmm->ErrDesc;
}
