/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_event_priv_h
#define INC_event_priv_h

/*
 * Definitions
 */

#define	KEYB_BUFFERSIZE			128

/*
 * Types
 */

/* Keymap entry */
struct KeymapEntry_t
{
    int		n;		/* without modifiers */
    int		s;		/* with Shift */
    int		ca;		/* with Ctrl and Alt / Alt Gr */
};

/* Key symbol */
struct Keysym_t
{
    uint16_t	code;		/* Code */
    char	name[20];	/* Name, this can be used in the keymap file */
};

/* Private data */
struct event_queue_private
{
    int				mBuffer[ KEYB_BUFFERSIZE ];
    struct KeymapEntry_t	mKeymap[ KEYB_BUFFERSIZE ];
    XMM_BufferQueue		bq;
    int				mod;

    /* Event callback */
    int				(*EventCB)( void *priv, XMM_Event *event );
    /* Private data: this is normally a backlink to the using object, eg. XMM_file */
    void			*priv_data;
    /* Never queue events ? */
    int				onlyCB;
};

/*
 * Global data
 */

/*
 * Key symbol names
 * used in keymap file
 */

static struct Keysym_t table_keysym[] =
{
    { 0,			"(No key)"	},	/* 000 */
    { 0,			"(???)"		},	/* 001 */
    { 0,			"(???)"		},	/* 002 */
    { 0,			"(???)"		},	/* 003 */
    { 0,			"(???)"		},	/* 004 */
    { 0,			"(???)"		},	/* 005 */
    { 0,			"(???)"		},	/* 006 */
    { 0,			"(???)"		},	/* 007 */
    { XMM_KEYSYM_BACKSPACE,	"BACKSPACE"	},	/* 008 */
    { XMM_KEYSYM_TAB,		"TAB"		},	/* 009 */
    { 0,			"(???)"		},	/* 010 */
    { 0,			"(???)"		},	/* 011 */
    { 0,			"(???)"		},	/* 012 */
    { XMM_KEYSYM_ENTER,		"ENTER"		},	/* 013 */
    { XMM_KEYSYM_DELETE,	"DELETE"	},	/* 014 */
    { XMM_KEYSYM_F1,		"F1"		},	/* 015 */
    { XMM_KEYSYM_F2,		"F2"		},	/* 016 */
    { XMM_KEYSYM_F3,		"F3"		},	/* 017 */
    { XMM_KEYSYM_F4,		"F4"		},	/* 018 */
    { XMM_KEYSYM_F5,		"F5"		},	/* 019 */
    { XMM_KEYSYM_F6,		"F6"		},	/* 020 */
    { XMM_KEYSYM_F7,		"F7"		},	/* 021 */
    { XMM_KEYSYM_F8,		"F8"		},	/* 022 */
    { XMM_KEYSYM_F9,		"F9"		},	/* 023 */
    { XMM_KEYSYM_F10,		"F10"		},	/* 024 */
    { XMM_KEYSYM_F11,		"F11"		},	/* 025 */
    { XMM_KEYSYM_F12,		"F12"		},	/* 026 */
    { XMM_KEYSYM_ESCAPE,	"ESCAPE"	},	/* 027 */
    { XMM_KEYSYM_UP,		"UP"		},	/* 028 */
    { XMM_KEYSYM_DOWN,		"DOWN"		},	/* 029 */
    { XMM_KEYSYM_LEFT,		"LEFT"		},	/* 030 */
    { XMM_KEYSYM_RIGHT,		"RIGHT"		},	/* 031 */
    { XMM_KEYSYM_SPACE,		"SPACE"		},	/* ' ' */
    { XMM_KEYSYM_EXCLAIM,	"EXCLAIM"	},	/* '!' */
    { XMM_KEYSYM_QUOTEDBL,	"QUOTEDBL"	},	/* '"' */
    { XMM_KEYSYM_HASH,		"HASH"		},	/* '#' */
    { XMM_KEYSYM_DOLLAR,	"DOLLAR"	},	/* '$' */
    { XMM_KEYSYM_PERCENT,	"PERCENT"	},	/* '%' */
    { XMM_KEYSYM_AMPERSAND,	"AMPERSAND"	},	/* '&' */
    { XMM_KEYSYM_QUOTE, 	"QUOTE"		},	/* ''' */
    { XMM_KEYSYM_LEFTPAREN,	"LEFTPAREN"	},	/* '(' */
    { XMM_KEYSYM_RIGHTPAREN,	"RIGHTPAREN"	},	/* ')' */
    { XMM_KEYSYM_ASTERISK,	"ASTERISK"	},	/* '*' */
    { XMM_KEYSYM_PLUS,		"PLUS"		},	/* '+' */
    { XMM_KEYSYM_COMMA,		"COMMA"		},	/* ',' */
    { XMM_KEYSYM_MINUS,		"MINUS"		},	/* '-' */
    { XMM_KEYSYM_PERIOD,	"PERIOD"	},	/* '.' */
    { XMM_KEYSYM_SLASH,		"SLASH"		},	/* '/' */
    { XMM_KEYSYM_0,		"XMM_KEYSYM_0"	},	/* '0' */
    { XMM_KEYSYM_1,		"XMM_KEYSYM_1"	},	/* '1' */
    { XMM_KEYSYM_2,		"XMM_KEYSYM_2"	},	/* '2' */
    { XMM_KEYSYM_3,		"XMM_KEYSYM_3"	},	/* '3' */
    { XMM_KEYSYM_4,		"XMM_KEYSYM_4"	},	/* '4' */
    { XMM_KEYSYM_5,		"XMM_KEYSYM_5"	},	/* '5' */
    { XMM_KEYSYM_6,		"XMM_KEYSYM_6"	},	/* '6' */
    { XMM_KEYSYM_7,		"XMM_KEYSYM_7"	},	/* '7' */
    { XMM_KEYSYM_8,		"XMM_KEYSYM_8"	},	/* '8' */
    { XMM_KEYSYM_9,		"XMM_KEYSYM_9"	},	/* '9' */
    { XMM_KEYSYM_COLON,		"COLON"		},	/* ':' */
    { XMM_KEYSYM_SEMICOLON,	"SEMICOLON"	},	/* ';' */
    { XMM_KEYSYM_LESS,		"LESS"		},	/* '<' */
    { XMM_KEYSYM_EQUALS,	"EQUALS"	},	/* '=' */
    { XMM_KEYSYM_GREATER,	"GREATER"	},	/* '>' */
    { XMM_KEYSYM_QUESTION,	"QUESTION"	},	/* '?' */
    { XMM_KEYSYM_AT,		"AT"		},	/* '@' */
    { XMM_KEYSYM_A,		"A"		},	/* 'A' */
    { XMM_KEYSYM_B,		"B"		},	/* 'B' */
    { XMM_KEYSYM_C,		"C"		},	/* 'C' */
    { XMM_KEYSYM_D,		"D"		},	/* 'D' */
    { XMM_KEYSYM_E,		"E"		},	/* 'E' */
    { XMM_KEYSYM_F,		"F"		},	/* 'F' */
    { XMM_KEYSYM_G,		"G"		},	/* 'G' */
    { XMM_KEYSYM_H,		"H"		},	/* 'H' */
    { XMM_KEYSYM_I,		"I"		},	/* 'I' */
    { XMM_KEYSYM_J,		"J"		},	/* 'J' */
    { XMM_KEYSYM_K,		"K"		},	/* 'K' */
    { XMM_KEYSYM_L,		"L"		},	/* 'L' */
    { XMM_KEYSYM_M,		"M"		},	/* 'M' */
    { XMM_KEYSYM_N,		"N"		},	/* 'N' */
    { XMM_KEYSYM_O,		"O"		},	/* 'O' */
    { XMM_KEYSYM_P,		"P"		},	/* 'P' */
    { XMM_KEYSYM_Q,		"Q"		},	/* 'Q' */
    { XMM_KEYSYM_R,		"R"		},	/* 'R' */
    { XMM_KEYSYM_S,		"S"		},	/* 'S' */
    { XMM_KEYSYM_T,		"T"		},	/* 'T' */
    { XMM_KEYSYM_U,		"U"		},	/* 'U' */
    { XMM_KEYSYM_V,		"V"		},	/* 'V' */
    { XMM_KEYSYM_W,		"W"		},	/* 'W' */
    { XMM_KEYSYM_X,		"X"		},	/* 'X' */
    { XMM_KEYSYM_Y,		"Y"		},	/* 'Y' */
    { XMM_KEYSYM_Z,		"Z"		},	/* 'Z' */
    { XMM_KEYSYM_LEFTBRACKET,	"LEFTBRACKET"	},	/* '[' */
    { XMM_KEYSYM_BACKSLASH,	"BACKSLASH"	},	/* '\' */
    { XMM_KEYSYM_RIGHTBRACKET,	"RIGHTBRACKET"	},	/* ']' */
    { XMM_KEYSYM_CARET,		"CARET"		},	/* '^' */
    { XMM_KEYSYM_UNDERSCORE,	"UNDERSCORE"	},	/* '_' */
    { XMM_KEYSYM_BACKQUOTE,	"BACKQUOTE"	},	/* '`' */
    { XMM_KEYSYM_a,		"a"		},	/* 'a' */
    { XMM_KEYSYM_b,		"b"		},	/* 'b' */
    { XMM_KEYSYM_c,		"c"		},	/* 'c' */
    { XMM_KEYSYM_d,		"d"		},	/* 'd' */
    { XMM_KEYSYM_e,		"e"		},	/* 'e' */
    { XMM_KEYSYM_f,		"f"		},	/* 'f' */
    { XMM_KEYSYM_g,		"g"		},	/* 'g' */
    { XMM_KEYSYM_h,		"h"		},	/* 'h' */
    { XMM_KEYSYM_i,		"i"		},	/* 'i' */
    { XMM_KEYSYM_j,		"j"		},	/* 'j' */
    { XMM_KEYSYM_k,		"k"		},	/* 'k' */
    { XMM_KEYSYM_l,		"l"		},	/* 'l' */
    { XMM_KEYSYM_m,		"m"		},	/* 'm' */
    { XMM_KEYSYM_n,		"n"		},	/* 'n' */
    { XMM_KEYSYM_o,		"o"		},	/* 'o' */
    { XMM_KEYSYM_p,		"p"		},	/* 'p' */
    { XMM_KEYSYM_q,		"q"		},	/* 'q' */
    { XMM_KEYSYM_r,		"r"		},	/* 'r' */
    { XMM_KEYSYM_s,		"s"		},	/* 's' */
    { XMM_KEYSYM_t,		"t"		},	/* 't' */
    { XMM_KEYSYM_u,		"u"		},	/* 'u' */
    { XMM_KEYSYM_v,		"v"		},	/* 'v' */
    { XMM_KEYSYM_w,		"w"		},	/* 'w' */
    { XMM_KEYSYM_x,		"x"		},	/* 'x' */
    { XMM_KEYSYM_y,		"y"		},	/* 'y' */
    { XMM_KEYSYM_z,		"z"		},	/* 'z' */
    { XMM_KEYSYM_LEFTBRACE,	"LEFTBRACE"	},	/* '{' */
    { XMM_KEYSYM_BAR,		"BAR"		},	/* '|' */
    { XMM_KEYSYM_RIGHTBRACE,	"RIGHTBRACE"	},	/* '}' */
    { XMM_KEYSYM_TILDE,		"TILDE"		},	/* '~' */
    { 0,			"(???)"		},	/* 127 */
    /* Non ASCII without character */
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    /* 0x100 - unused */
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" }, { 0, "(???)" },
    { 0, "(???)" }, { 0, "(???)" },
    /* 0x110 - modifier keys */
    { XMM_KEYSYM_LSHIFT,	"LSHIFT"	},
    { XMM_KEYSYM_RSHIFT,	"RSHIFT"	},
    { XMM_KEYSYM_LCTRL,		"LCTRL"		},
    { XMM_KEYSYM_RCTRL,		"RCTRL"		},
    { XMM_KEYSYM_LALT,		"LALT"		},
    { XMM_KEYSYM_RALT,		"RALT"		},
    { XMM_KEYSYM_LMETA,		"LMETA"		},
    { XMM_KEYSYM_RMETA,		"RMETA"		},
    { XMM_KEYSYM_NUM,		"NUM"		},
    { XMM_KEYSYM_CAPS,		"CAPS"		},
    { XMM_KEYSYM_SCROLL,	"SCROLL"	},
    { 0,			"" }
};

#endif
