/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * bitstream.c
 * Bitstream / getbits implementation
 */

#include <stdio.h>
#include "libxmm/util/utils.h"
#include "libxmm/util/bitstream.h"

/*
 * Initialize bitstream ( from data buffer )
 */

void xmmBS_Init( XMM_BitStream *bs, uint8_t *data, int size )
{
  bs->buffer = 0;
  bs->bitindex = 0;
  bs->bitcount = 0;
  bs->data = data;
  bs->size = size;
}

/*
 * Get ( up to 32 ) bits from stream
 */

uint32_t xmmBS_Get( XMM_BitStream *bs, int bits )
{
  uint32_t ret;

  while( bs->bitindex < bits )
  {
	bs->buffer <<= 8;

	if( bs->data )
	{
#ifdef XMM_BS_CHECK_OVERRUN
		if( bs->size <= 0 )
		{
#ifdef XMM_BS_VERBOSE
			xmm_logging( 1, "XMM! BitStream: Need more data\n" );
#endif
			return 0;
		}
		bs->size--;
#endif
		bs->buffer |= *bs->data++;
	}
	bs->bitcount += 8;
	bs->bitindex += 8;

#ifdef XMM_BS_VERBOSE
	xmm_logging( 1, "XMM! BitStream: 1 byte added ( buffer = %x, count = %i, index = %i\n", bs->buffer, bs->bitcount, bs->bitindex );
#endif
  }

  bs->bitindex -= bits;

  ret = bs->buffer >> bs->bitindex;
  ret &= ( 0xffffffff >> ( 32 - bits ));

#ifdef XMM_BS_VERBOSE
  xmm_logging( 1, "XMM! BitStream: got %i bits: %x\n", bits, ret );
#endif
  return ret;
}
