/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * list.c
 * List structure
 */

#include <stdio.h>
#include <stdlib.h>
#include "libxmm/util/list.h"
#include "libxmm/util/utils.h"

/*
 * Add element to list
 */

XMM_List *xmmList_Append( XMM_List *list, void *data )
{
  XMM_List *new = NULL, *last;

  if(( new = malloc( sizeof( XMM_List ))) == NULL )
  {
	xmm_logging( 1, "xmmList_Append: error allocating memory for new node\n" );
	return NULL;
  }

  new->data = data;
  new->next = NULL;
  new->prev = NULL;

  if( list == NULL )	return new;
  else
  {
	for( last = list; last->next; last = last->next );
	last->next = new;
	new->prev = last;
	return list;
  }
}

/*
 * Free hole list
 */

void xmmList_Free( XMM_List *list )
{
  if( list )
  {
	xmmList_Free( list->next );
	free( list );
  }
}

/*
 * Remove element with specified key from list
 */

XMM_List *xmmList_Remove( XMM_List *list, void *key )
{
  XMM_List *le, *rem;

  if( list == NULL )	return NULL;

  if( list == key )
  {
	le = list->next;
	free( list );
	return le;
  }

  for( le = list; le->next && ( le->next->data != key ); le = le->next );

  if( le == NULL )	return list;

  rem = le->next;
  le->next = le->next->next;
  free( rem );

  return list;
}
