/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * mutex.c
 * Mutex implementation using pthread
 */

#include <stdlib.h>
#include <pthread.h>
#include "libxmm/xmmp.h"
#include "libxmm/error.h"
#include "libxmm/util/mutex.h"

/*
 * Create mutex
 */
XMM_Mutex *xmmMutex_Create( void )
{
  pthread_mutex_t	*mutex;
#if 0
  pthread_mutexattr_t	attr;
#endif

  /* Allocate */
  if(( mutex = malloc( sizeof( pthread_mutex_t ))) == NULL )	return NULL;

  /* Set attributes */
#if 0
  pthread_mutexattr_init( &attr );
  pthread_mutexattr_settype( &attr, PTHREAD_MUTEX_RECURSIVE_NP );
#endif

  /* Initialize mutex */
#if 0
  pthread_mutex_init((pthread_mutex_t *)mutex, &attr );
#else
  pthread_mutex_init((pthread_mutex_t *)mutex, NULL );
#endif

  /* Destroy mutex attribute */
#if 0
  pthread_mutexattr_destroy( &attr );
#endif

  return (XMM_Mutex *) mutex;
}

/*
 * Destroy mutex
 */
void xmmMutex_Destroy( XMM_Mutex *mutex )
{
  if( mutex == NULL )	return;

  /* Destroy */
  pthread_mutex_destroy((pthread_mutex_t *) mutex );

  free( mutex );
}

/*
 * Lock mutex
 */
int xmmMutex_Lock( XMM_Mutex *mutex )
{
  int ret = XMM_RET_OK;

  if( mutex == NULL )	return XMM_RET_INVALID_ARG;

  /* Lock */
  if( pthread_mutex_lock((pthread_mutex_t *) mutex ) != 0 )	ret = XMM_RET_ERROR;

  return ret;
}

/*
 * Unlock mutex
 */
int xmmMutex_Unlock( XMM_Mutex *mutex )
{
  int ret = XMM_RET_OK;

  if( mutex == NULL )	return XMM_RET_INVALID_ARG;

  /* Unlock */
  if( pthread_mutex_unlock((pthread_mutex_t *) mutex ) != 0 )	ret = XMM_RET_ERROR;

  return ret;
}

/*
 * Try locking mutex
 */
int xmmMutex_TryLock( XMM_Mutex *mutex )
{
  int ret = XMM_RET_OK;

  if( mutex == NULL )	return XMM_RET_INVALID_ARG;

  /* Try locking */
  if( pthread_mutex_trylock((pthread_mutex_t *) mutex ) != 0 )	ret = XMM_RET_ERROR;

  return ret;
}
