/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_xmmpriv_h
#define INC_libxmm_xmmpriv_h

#include "libxmm/util/list.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct xmm_s
{
    /* Plugin lists */
    XMM_List			*pIOList;
    XMM_List			*pInputList;
    XMM_List			*pCodecList;

    /* Event */
    void			*pEQpriv;

    /* Error */
    int				Errno;
    char			ErrDesc[256];

    /* Audio Filter */
    void			*pAFpriv;
    /* Video Filter */
    void			*pVFpriv;

    /* plugin names */
    char			output_plugin[256];
    char			graph_plugin[256];
    char			sound_plugin[256];
    char			gconv_plugin[256];

    /* Input filename, Output filename some output plugins need this */
    char			*iFilename;
    char			*oFilename;
} XMM;

#ifdef __cplusplus
}
#endif

#endif
