/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_avimpeg_h
#define INC_avimpeg_h

#include <inttypes.h>

/*
 * MPEG Audio Layer 3
 */

/*
 * Definitions
 */

#define	WAVE_MP3_EXTRA_SIZE		0x000C

	/* ID */
#define WAVE_MP3_ID_UNKNOWN		0x0000
#define WAVE_MP3_ID_MPEG		0x0001
#define WAVE_MP3_ID_CONSTANTFRAMESIZE	0x0002

	/* Flags */
#define WAVE_MP3_FLAG_PADDING_ISO	0x00000000
#define WAVE_MP3_FLAG_PADDING_ON	0x00000001
#define WAVE_MP3_FLAG_PADDING_OFF	0x00000002

/*
 * Type
 */

typedef struct __attribute__((packed)) wave_mp3format_s
{
    uint16_t		wID;			/* Type ID */
    uint32_t		dwFlags;		/* Flags */
    uint16_t		nBlockSize;		/* Blocksize */
    uint16_t		nFramesPerBlock;	/* Frames / Block */
    uint16_t		nCodecDelay;		/* ??? */
} wave_mp3format_t;

#endif
