/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * null.c
 * dummy graph
 */

#include <stdio.h>
#include <stdlib.h>

#include <libxmm/xmmp.h>
#include <libxmm/version.h>
#include <libxmm/lpgraph.h>
#include <libxmm/xmmctl.h>
#include <libxmm/error.h>
#include <libxmm/util/utils.h>

/*
 * Global data
 */

extern XMM_PluginGraph	plugin_info;

/*
 * Types
 */

struct priv_t
{
    int		pixelsize;
};

/*
 * Initialize
 */

static XMM_PluginGraph *null_Init( void *xmm )
{
  XMM_PluginGraph	*graph;
  struct priv_t		*priv;

  /*
   * Alocate plugin data and private data
   */

  if(( graph = xmm_memdup_x( &plugin_info, sizeof( XMM_PluginGraph ), sizeof( struct priv_t ))) == NULL )
  {
	xmm_SetError( xmm, XMM_ERR_ALLOC, __FUNCTION__ "() Unable to duplicate plugin_info" );
	return NULL;
  }

  /*
   * These have to be initialized
   */

  priv = (struct priv_t *) &graph[1];
  graph->sys.priv = (void *) priv;
  graph->sys.xmm = xmm;

  /* Initialize some data */
  priv->pixelsize = 2;

  /* Return object */
  return graph;
}

/*
 * Close
 */

static void null_Exit( XMM_PluginGraph *graph )
{
  free( graph );
}

/*
 * Control
 */

static int null_Control( XMM_PluginGraph *graph, uint32_t cmd, uint32_t param, void *data )
{
  struct priv_t *priv = graph->sys.priv;

  switch( cmd )
  {
    case XMM_CTLQUERY_HWSCALE:
	    return XMM_CTLRET_FALSE;
	    
    case XMM_CTLQUERY_YFLIP:
	    return XMM_CTLRET_FALSE;

    case XMM_CTLQUERY_FULLSCREEN:
	    return XMM_CTLRET_TRUE;

    case XMM_CTLQUERY_GFORMAT:
	    return XMM_CTLRET_TRUE;

    case XMM_CTLQUERY_SURFACE_READ:
	    return XMM_CTLRET_TRUE;
    
    case XMM_CTLGET_GFORMAT:
	    *((uint32_t *)data) = xmmFOURCC( 'R','G','B', priv->pixelsize * 8 );
	    return XMM_CTLRET_ARG;		/* Result in arg */
	    
    case XMM_CTLGET_SURFACE:
	    return XMM_CTLRET_NOTSUPPORTED;

    case XMM_CTLSET_SCALE:
	    return XMM_CTLRET_TRUE;

    case XMM_CTLSET_POSITION:
	    return XMM_CTLRET_NOTSUPPORTED;		/* window position */

    case XMM_CTLSET_TITLE:
	    return XMM_CTLRET_NOTSUPPORTED;		/* window title */

    default:
	    break;
  }

  if( cmd & XMM_CTLMASK_GRAPH )	return XMM_CTLRET_UNKNOWN;
  return XMM_CTLRET_INVALID;	/* No GRAPH command */
}

/*
 * Start Graph Output
 */

static int null_Start( XMM_PluginGraph *graph, int width, int height, uint32_t format, int flags )
{
  return XMM_RET_OK;
}

/*
 * Draw frame ( or part of it )
 */

static void null_Draw( XMM_PluginGraph *graph, uint8_t *data[], int stride[], int x, int y, int width, int height, int flag )
{
}

/*
 * Blit to screen
 */

static void null_Blit( XMM_PluginGraph *graph )
{
}

/*
 * Plugin info
 */

XMM_PluginGraph	plugin_info = {	{ NULL,
				XMM_PLUGIN_ID,
				XMM_PLUGIN_TYPE_GRAPH,
				0,
				XMM_VERSION_NUM,
				"",
				"NULL",
				"Graph: NULL",
				"Copyright (c) 2000, 2001 by Arthur Kleer",
				NULL, NULL },
				null_Init, null_Exit, null_Control, null_Start,
				null_Draw, null_Blit };
