/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * x11_shm.c
 * X11 Shared Memory Extension
 */

#include <string.h>
#include <errno.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

#include <libxmm/util/utils.h>

XImage *xshm_Create( Display *display, Visual *visual, XShmSegmentInfo *ShmInfo, int width, int height, int bpp )
{
  XImage *image;

  /* Create image */
  image = XShmCreateImage( display, visual, bpp, ZPixmap, NULL, ShmInfo, width, height );
  if( image == NULL )
  {
	xmm_logging( 1, "X11! Unable to create Shared memory image\n" );
	return NULL;
  }

  ShmInfo->shmid = shmget( IPC_PRIVATE, image->bytes_per_line * image->height, IPC_CREAT | 0777 );

  if( ShmInfo->shmid < 0 )
  {
	XDestroyImage( image );
	xmm_logging( 1, "X11! Shared memory error, ( seg id error: %s )\n", strerror( errno ));
	return NULL;
  }

  if((int)( ShmInfo->shmaddr = shmat( ShmInfo->shmid, 0, 0 )) == -1 )
  {
	XDestroyImage( image );
	xmm_logging( 1, "X11! Shared memory error, ( address error )\n" );
	return NULL;
  }

  ShmInfo->readOnly = False;
  XShmAttach( display, ShmInfo );

  return image;
}

void xshm_Destroy( Display *display, XShmSegmentInfo *ShmInfo )
{
  XShmDetach( display, ShmInfo );
  shmdt( ShmInfo->shmaddr );
  shmctl( ShmInfo->shmid, IPC_RMID, 0 );
}
