/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_avifmt_h
#define INC_avifmt_h

#include <inttypes.h>

/*
 * RIFF Chunk ID's
 */

#define	RIFF_ID_RIFF	0x46464952	/* 'RIFF' */
#define RIFF_ID_AVI	0x20495641	/* 'AVI ' */
#define	RIFF_ID_LIST	0x5453494c	/* 'LIST' */
#define	RIFF_ID_hdrl	0x6C726468	/* 'hdrl' - LIST Header chunks */
#define RIFF_ID_avih	0x68697661	/* 'avih' - AVI main header */
#define	RIFF_ID_strl	0x6C727473	/* 'strl' - LIST Stream Header chunks */
#define	RIFF_ID_strh	0x68727473	/* 'strh' - Stream Header */
#define	RIFF_ID_strf	0x66727473	/* 'strf' - Stream Format */
#define	RIFF_ID_strd	0x64727473	/* 'strd' - Stream Data */
#define RIFF_ID_strn	0x6E727473	/* 'strn' - Stream Name */
#define	RIFF_ID_JUNK	0x4b4e554a	/* 'JUNK' - data alignment  */

#define	RIFF_ID_movi	0x69766f6d	/* 'movi' - LIST 'movi' chunk */
#define RIFF_ID_rec	0x20636572	/* 'rec ' - LIST 'rec ' chunk */
#define	RIFF_ID_01wb	0x62773130	/* 'wb'   - waveform chunk */
#define	RIFF_ID_00dc	0x63643030	/* 'dc'   - DIB compressed */
#define	RIFF_ID_00db	0x62643030	/* 'db'   - DIB bits ( uncompressed ) */
#define RIFF_ID_idx1	0x31786469	/* 'idx1' - List of data chunks */

#define	RIFF_ID_odml	0x6c6d646f	/* ??? */
#define	RIFF_ID_dmlh	0x686c6d64	/* ??? */

/*
 * AVI stream header types
 */

#define	RIFF_STREAM_VIDEO		0x73646976	/* 'vids' */
#define	RIFF_STREAM_AUDIO		0x73647561	/* 'auds' */
#define RIFF_STREAM_MIDI		0x7364696d	/* 'mids' */
#define RIFF_STREAM_TEXT		0x73727872	/* 'txts' */

/*
 * ( RIFF ) AVI Header Flags
 */

	/* has an "idx1" chunk */
#define	AVIF_HASINDEX		0x00000010
	/* use idx1 chunk to determine the order of presentation of the data */
#define	AVIF_MUSTUSEINDEX	0x00000020
	/* AVI file is interleaved */
#define	AVIF_ISINTERLEAVED	0x00000100
	/* TODO : What is this ??? */
#define AVIF_TRUSTCKTYPE	0x00000800
	/* AVI file is used for capturing real-time video */
#define	AVIF_WASCAPTUREFILE	0x00010000
	/* Indicates the AVI file contains copyrighted data. */
#define	AVIF_COPYRIGHTED	0x00020000

/*
 * ( RIFF ) AVI stream header flags
 */

	/* Only render when explicitly enabled by user */
#define	AVISF_DISABLED		0x00000001
	/* Palette changes embedded in the file */
#define	AVISF_VIDEO_PALCHANGES	0x00010000

/*
 * AVI index entry flags
 */

	/* Chunk is LIST chunk */
#define AVIIF_LIST          0x00000001L
	/* keyframe doesn't need previous info to be decompressed */
#define AVIIF_KEYFRAME      0x00000010L
	/* Chunk does not affect timing of video stream, ie palette change */
#define AVIIF_NOTIME        0x00000100L

/*
 * Types
 */

/*
 * AVI Header
 */

typedef struct avi_header_s
{
    uint32_t	dwMicroSecPerFrame;
		/* Time / Frame */
    uint32_t	dwMaxBytesPerSec;
		/* Maximum transfer rate */
    uint32_t	dwReserved1;
    uint32_t	dwFlags;
    uint32_t	dwTotalFrames;
			/* Number of frames in file */
    uint32_t	dwInitialFrames;
    uint32_t	dwStreams;
    uint32_t	dwSuggestedBufferSize;
    uint32_t	dwWidth;
    uint32_t	dwHeight;
    uint32_t	dwScale;
    uint32_t	dwRate;
    uint32_t	dwStart;
    uint32_t	dwLength;
} avi_header_t;

/*
 * AVI Stream Header
 */

typedef struct avi_stream_header_s
{
    uint32_t	fccType;		/* 'vids' for video, 'auds' for audio */
    uint32_t	fccHandler;		/* compressor/decompressor fourcc */
    uint32_t	dwFlags;		/* Flags, AVIF_* */
    uint32_t	dwReserved1;
    uint32_t	dwInitialFrames;	/* used for interleaved files */
    uint32_t	dwScale;
    uint32_t	dwRate;			/* dwRate / dwScale = samples / sec */
    uint32_t	dwStart;		/* Starting time */
    uint32_t	dwLength;		/* Length */
    uint32_t	dwSuggestedBufferSize;	/* Size of playback buffer */
    uint32_t	dwQuality;		/* Data quality */
    uint32_t	dwSampleSize;		/* Sample size */
    uint16_t	dwReserved2[4];		/* rcFrame ( left, top, right, bottom ) */
} avi_stream_header_t;

/*
 * AVI Index entry
 */

typedef struct avi_index_entry_s
{
    uint32_t	dwChunkID;		/* FOURCC of the chunk */
    uint32_t	dwFlags;		/* Flags */
    uint32_t	dwChunkOffset;		/* Position of chunk */
    uint32_t	dwChunkLength;		/* Length of chunk */
} avi_index_entry_t;

/*
 * Bitmap format header
 *
 * defined in wingdi.h ( wine )
 */

#ifndef __WINE_WINGDI_H

typedef struct _BITMAPINFOHEADER
{
    uint32_t 	biSize;			/* long */
    uint32_t  	biWidth;		/* long */
    uint32_t  	biHeight;		/* long */
    uint16_t	biPlanes;		/* short */
    uint16_t	biBitCount;		/* short */
    uint32_t	biCompression;		/* long */
    uint32_t	biSizeImage;		/* long */
    uint32_t	biXPelsPerMeter;	/* long */
    uint32_t	biYPelsPerMeter;	/* long */
    uint32_t	biClrUsed;		/* long */
    uint32_t	biClrImportant;		/* long */
} BITMAPINFOHEADER;

typedef struct _BITMAPINFO
{
    BITMAPINFOHEADER	bmiHeader;
    int			bmiColors[1];
} BITMAPINFO;

#endif

/*
 * WAVE format header
 */

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_

typedef struct _WAVEFORMATEX
{
    uint16_t	wFormatTag;		/* Format */
    uint16_t	nChannels;		/* Channels */
    uint32_t	nSamplesPerSec;		/* Rate */
    uint32_t	nAvgBytesPerSec;	/* Average bytes / sec */
    uint16_t	nBlockAlign;		/* block size of data */
    uint16_t	wBitsPerSample;		/* Number of bits per sample */
    uint16_t	cbSize;			/* Size of extra data */
} WAVEFORMATEX;

#endif

#endif
