/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_reader_h
#define INC_reader_h

#include <libxmm/xmmp.h>

/*
 * Definitions
 */

#define	MAX_STREAMS		0x10

/*
 * Types
 */

typedef struct Reader_s		Reader_t;

struct Reader_s
{
    void			*priv;
    void			(*Close)( Reader_t *reader );

    XMM_FileInfo		*(*FileInfo)( Reader_t *reader );

    XMM_VideoFormat		*(*VideoFormat)( Reader_t *reader, int stream );
    uint32_t			(*VideoRead)( Reader_t *reader, int stream, char **dest, uint32_t *dsize );
    uint32_t			(*VideoSeek)( Reader_t *reader, int stream, uint32_t frame, int keyframe );

    XMM_AudioFormat		*(*AudioFormat)( Reader_t *reader, int stream );
    uint32_t			(*AudioRead)( Reader_t *reader, int stream, char **dest, uint32_t *dsize );
    uint32_t			(*AudioSeek)( Reader_t *reader, int stream, uint32_t bytes );

    uint32_t			(*CurrentFrame)( Reader_t *reader, int stream );
    uint32_t			(*TotalFrames)( Reader_t *reader );

    double			(*CurrentTime)( Reader_t *reader );
    double			(*TotalTime)( Reader_t *reader );
};


/*
 * Prototypes
 */

Reader_t *ReaderOpen_avi( void *xmm, XMM_PluginIO *pIO );
#define	ReaderOpen	ReaderOpen_avi

#endif
