/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_cdda_h
#define INC_cdda_h

//
// Definitions
//

#define	CDDA_MAX_TRACKS		100

#define	CDDA_ARTIST_MULTIPLE	1
#define	CDDA_ARTIST_SINGLE	2

#define LBA(te)			(( te.minute * 60 + te.second ) * 75 + te.frame )

//
// Types
//

struct cdr_tocentry
{
	unsigned char		minute;
	unsigned char		second;
	unsigned char		frame;
	unsigned char		type;
};

struct cdr_trackdata
{
	char 			Artist[256];
	char 			Title[256];
};

struct cdr_discdata
{
	char			Title[256];
	int			ArtistType;
	struct cdr_trackdata	Track[CDDA_MAX_TRACKS];
};

//
// Prototypes
//

int cdindex_get_info( void *xmm, char *cdindex_server, int FirstTrack, int LastTrack, struct cdr_tocentry *Track, struct cdr_discdata *Data );

#endif
