/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * mikmod driver. I used drv_stdout as reference.
 */

#include <mikmod.h>
#include <libxmm/libxmm.h>
#include "priv.h"

/*
 * Global data
 */

extern struct priv_t *mikmod_priv;

/*
 * Functions
 */

static BOOL xmm_IsPresent( void )
{
  return 1;
}

static BOOL xmm_Reset( void )
{
  VC_Exit();
  return VC_Init();
}

static void xmm_Update( void )
{
  int size;

  size = VC_WriteBytes( (SBYTE *) mikmod_priv->abuffer, mikmod_priv->abuffersize * mikmod_priv->bps );
  mikmod_priv->pSound->Write( mikmod_priv->pSound, mikmod_priv->abuffer, size / mikmod_priv->bps );
}

/*
 * Driver data
 */

MIKMODAPI MDRIVER drv_xmm = {
	NULL,
	"xmm",
	"xmm output driver v1.0",
	0,
	255,
	"xmm",
	NULL,
	xmm_IsPresent,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	VC_Init,
	VC_Exit,
	xmm_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	VC_PlayStop,
	xmm_Update,
	NULL,
	VC_VoiceSetVolume,
	VC_VoiceGetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceGetFrequency,
	VC_VoiceSetPanning,
	VC_VoiceGetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};
