/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_MIKMOD_PRIV_H
#define INC_MIKMOD_PRIV_H

#include <libxmm/libxmm.h>
#include <libxmm/util/thread.h>

/*
 * Types
 */

struct priv_t
{
    XMM_PluginSound		*pSound;
    XMM_AudioInfo		ai;

    char 			*mikmod_filename, mikmod_path[XMM_MAXPATHLEN];

    MODULE			*module;
    char			*abuffer;
    int				abuffersize, bps;

    XMM_Thread			*mikmod_thread;
    int				exit_mikmod_thread;

    struct mikmod_reader
    {
	MREADER			sys;
	XMM_PluginIO		*pIO;
    } mreader;
};

#endif
