/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

GtkWidget*
create_mpg123_about_window (void)
{
  GtkWidget *mpg123_about_window;
  GtkWidget *about_vbox;
  GtkWidget *about_label;
  GtkWidget *about_hsep;
  GtkWidget *about_close;

  mpg123_about_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (mpg123_about_window), "mpg123_about_window", mpg123_about_window);
  gtk_container_set_border_width (GTK_CONTAINER (mpg123_about_window), 10);
  gtk_window_set_title (GTK_WINDOW (mpg123_about_window), _("About MPG123 plugin"));
  gtk_window_set_modal (GTK_WINDOW (mpg123_about_window), TRUE);
  gtk_window_set_policy (GTK_WINDOW (mpg123_about_window), FALSE, FALSE, FALSE);

  about_vbox = gtk_vbox_new (FALSE, 6);
  gtk_widget_ref (about_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_about_window), "about_vbox", about_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_vbox);
  gtk_container_add (GTK_CONTAINER (mpg123_about_window), about_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (about_vbox), 5);

  about_label = gtk_label_new (_("MPEG 1.0 / 2.0 / 2.5 Layer 1/2/3 Plugin\nfor\nLinuX MultiMedia Project\n\nCopyright (c) 2000, 2001 Arthur Kleer\n\nBased on mpg123 by Michael Hipp\nWebsite: www.mpg123.org"));
  gtk_widget_ref (about_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_about_window), "about_label", about_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_label);
  gtk_box_pack_start (GTK_BOX (about_vbox), about_label, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (about_label), 0, 16);

  about_hsep = gtk_hseparator_new ();
  gtk_widget_ref (about_hsep);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_about_window), "about_hsep", about_hsep,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_hsep);
  gtk_box_pack_start (GTK_BOX (about_vbox), about_hsep, FALSE, FALSE, 0);

  about_close = gtk_button_new_with_label (_("Close"));
  gtk_widget_ref (about_close);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_about_window), "about_close", about_close,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_close);
  gtk_box_pack_start (GTK_BOX (about_vbox), about_close, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (about_close), 5);

  gtk_signal_connect_object (GTK_OBJECT (about_close), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (mpg123_about_window));

  return mpg123_about_window;
}

GtkWidget*
create_mpg123_pref_window (void)
{
  GtkWidget *mpg123_pref_window;
  GtkWidget *pref_vbox;
  GtkWidget *pref_nb;
  GtkWidget *pref_general_vbox;
  GtkWidget *pref_general_label;
  GtkWidget *pref_general_page;
  GtkWidget *pref_quality_vbox;
  GtkWidget *pref_quality_rate_frame;
  GtkWidget *pref_quality_rate_vbox;
  GSList *pref_quality_rate_group = NULL;
  GtkWidget *pref_quality_44khz;
  GtkWidget *pref_quality_22khz;
  GtkWidget *pref_quality_11khz;
  GtkWidget *pref_quality_hbox;
  GtkWidget *pref_quality_chan_frame;
  GtkWidget *pref_quality_chan_vbox;
  GSList *pref_quality_chan_group = NULL;
  GtkWidget *pref_quality_stereo;
  GtkWidget *pref_quality_mono;
  GtkWidget *pref_quality_size_frame;
  GtkWidget *pref_quality_size_vbox;
  GSList *pref_quality_size_group = NULL;
  GtkWidget *pref_quality_16bit;
  GtkWidget *pref_quality_8bit;
  GtkWidget *pref_quality_page;
  GtkWidget *pref_title_frame;
  GtkWidget *pref_title_vbox;
  GtkWidget *pref_title_disable_check;
  GtkWidget *pref_title_disp_hbox;
  GtkWidget *pref_title_disp_label;
  GtkWidget *pref_title_disp_entry;
  GtkWidget *pref_title_hsep;
  GtkWidget *pref_title_desc_hbox;
  GtkWidget *pref_title_desc1_label;
  GtkWidget *pref_title_desc2_label;
  GtkWidget *pref_title_desc3_label;
  GtkWidget *pref_title_page;
  GtkWidget *pref_hbbox;
  GtkWidget *pref_ok;
  GtkWidget *pref_cancel;

  mpg123_pref_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (mpg123_pref_window), "mpg123_pref_window", mpg123_pref_window);
  gtk_window_set_title (GTK_WINDOW (mpg123_pref_window), _("mpg123 Preferences..."));
  gtk_window_set_modal (GTK_WINDOW (mpg123_pref_window), TRUE);
  gtk_window_set_policy (GTK_WINDOW (mpg123_pref_window), TRUE, TRUE, FALSE);

  pref_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_vbox", pref_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_vbox);
  gtk_container_add (GTK_CONTAINER (mpg123_pref_window), pref_vbox);

  pref_nb = gtk_notebook_new ();
  gtk_widget_ref (pref_nb);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_nb", pref_nb,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_nb);
  gtk_box_pack_start (GTK_BOX (pref_vbox), pref_nb, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_nb), 10);

  pref_general_vbox = gtk_vbox_new (FALSE, 10);
  gtk_widget_ref (pref_general_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_general_vbox", pref_general_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_general_vbox);
  gtk_container_add (GTK_CONTAINER (pref_nb), pref_general_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (pref_general_vbox), 10);

  pref_general_label = gtk_label_new (_("Nothing yet..."));
  gtk_widget_ref (pref_general_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_general_label", pref_general_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_general_label);
  gtk_box_pack_start (GTK_BOX (pref_general_vbox), pref_general_label, FALSE, FALSE, 0);

  pref_general_page = gtk_label_new (_("General"));
  gtk_widget_ref (pref_general_page);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_general_page", pref_general_page,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_general_page);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_nb), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_nb), 0), pref_general_page);

  pref_quality_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_quality_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_vbox", pref_quality_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_vbox);
  gtk_container_add (GTK_CONTAINER (pref_nb), pref_quality_vbox);

  pref_quality_rate_frame = gtk_frame_new (_("Sample Rate"));
  gtk_widget_ref (pref_quality_rate_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_rate_frame", pref_quality_rate_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_rate_frame);
  gtk_box_pack_start (GTK_BOX (pref_quality_vbox), pref_quality_rate_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_quality_rate_frame), 5);

  pref_quality_rate_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_quality_rate_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_rate_vbox", pref_quality_rate_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_rate_vbox);
  gtk_container_add (GTK_CONTAINER (pref_quality_rate_frame), pref_quality_rate_vbox);

  pref_quality_44khz = gtk_radio_button_new_with_label (pref_quality_rate_group, _("44 kHz ( 1:1 )"));
  pref_quality_rate_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_44khz));
  gtk_widget_ref (pref_quality_44khz);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_44khz", pref_quality_44khz,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_44khz);
  gtk_box_pack_start (GTK_BOX (pref_quality_rate_vbox), pref_quality_44khz, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_quality_44khz), TRUE);

  pref_quality_22khz = gtk_radio_button_new_with_label (pref_quality_rate_group, _("22 kHz ( 1:2 )"));
  pref_quality_rate_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_22khz));
  gtk_widget_ref (pref_quality_22khz);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_22khz", pref_quality_22khz,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_22khz);
  gtk_box_pack_start (GTK_BOX (pref_quality_rate_vbox), pref_quality_22khz, FALSE, FALSE, 0);

  pref_quality_11khz = gtk_radio_button_new_with_label (pref_quality_rate_group, _("11 kHz ( 1:4 )"));
  pref_quality_rate_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_11khz));
  gtk_widget_ref (pref_quality_11khz);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_11khz", pref_quality_11khz,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_11khz);
  gtk_box_pack_start (GTK_BOX (pref_quality_rate_vbox), pref_quality_11khz, FALSE, FALSE, 0);

  pref_quality_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (pref_quality_hbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_hbox", pref_quality_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_hbox);
  gtk_box_pack_start (GTK_BOX (pref_quality_vbox), pref_quality_hbox, TRUE, TRUE, 0);

  pref_quality_chan_frame = gtk_frame_new (_("Channels"));
  gtk_widget_ref (pref_quality_chan_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_chan_frame", pref_quality_chan_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_chan_frame);
  gtk_box_pack_start (GTK_BOX (pref_quality_hbox), pref_quality_chan_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_quality_chan_frame), 5);

  pref_quality_chan_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_quality_chan_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_chan_vbox", pref_quality_chan_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_chan_vbox);
  gtk_container_add (GTK_CONTAINER (pref_quality_chan_frame), pref_quality_chan_vbox);

  pref_quality_stereo = gtk_radio_button_new_with_label (pref_quality_chan_group, _("Stereo"));
  pref_quality_chan_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_stereo));
  gtk_widget_ref (pref_quality_stereo);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_stereo", pref_quality_stereo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_stereo);
  gtk_box_pack_start (GTK_BOX (pref_quality_chan_vbox), pref_quality_stereo, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_quality_stereo), TRUE);

  pref_quality_mono = gtk_radio_button_new_with_label (pref_quality_chan_group, _("Mono"));
  pref_quality_chan_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_mono));
  gtk_widget_ref (pref_quality_mono);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_mono", pref_quality_mono,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_mono);
  gtk_box_pack_start (GTK_BOX (pref_quality_chan_vbox), pref_quality_mono, FALSE, FALSE, 0);

  pref_quality_size_frame = gtk_frame_new (_("Sample Size"));
  gtk_widget_ref (pref_quality_size_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_size_frame", pref_quality_size_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_size_frame);
  gtk_box_pack_start (GTK_BOX (pref_quality_hbox), pref_quality_size_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_quality_size_frame), 5);

  pref_quality_size_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_quality_size_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_size_vbox", pref_quality_size_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_size_vbox);
  gtk_container_add (GTK_CONTAINER (pref_quality_size_frame), pref_quality_size_vbox);

  pref_quality_16bit = gtk_radio_button_new_with_label (pref_quality_size_group, _("16 bit"));
  pref_quality_size_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_16bit));
  gtk_widget_ref (pref_quality_16bit);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_16bit", pref_quality_16bit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_16bit);
  gtk_box_pack_start (GTK_BOX (pref_quality_size_vbox), pref_quality_16bit, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_quality_16bit), TRUE);

  pref_quality_8bit = gtk_radio_button_new_with_label (pref_quality_size_group, _("8 bit"));
  pref_quality_size_group = gtk_radio_button_group (GTK_RADIO_BUTTON (pref_quality_8bit));
  gtk_widget_ref (pref_quality_8bit);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_8bit", pref_quality_8bit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_8bit);
  gtk_box_pack_start (GTK_BOX (pref_quality_size_vbox), pref_quality_8bit, FALSE, FALSE, 0);

  pref_quality_page = gtk_label_new (_("Quality"));
  gtk_widget_ref (pref_quality_page);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_quality_page", pref_quality_page,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_quality_page);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_nb), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_nb), 1), pref_quality_page);

  pref_title_frame = gtk_frame_new (_("ID3 Tag"));
  gtk_widget_ref (pref_title_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_frame", pref_title_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_frame);
  gtk_container_add (GTK_CONTAINER (pref_nb), pref_title_frame);
  gtk_container_set_border_width (GTK_CONTAINER (pref_title_frame), 5);

  pref_title_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (pref_title_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_vbox", pref_title_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_vbox);
  gtk_container_add (GTK_CONTAINER (pref_title_frame), pref_title_vbox);

  pref_title_disable_check = gtk_check_button_new_with_label (_("Disable ID3 tags"));
  gtk_widget_ref (pref_title_disable_check);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_disable_check", pref_title_disable_check,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_disable_check);
  gtk_box_pack_start (GTK_BOX (pref_title_vbox), pref_title_disable_check, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_title_disable_check), 5);

  pref_title_disp_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (pref_title_disp_hbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_disp_hbox", pref_title_disp_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_disp_hbox);
  gtk_box_pack_start (GTK_BOX (pref_title_vbox), pref_title_disp_hbox, TRUE, TRUE, 0);

  pref_title_disp_label = gtk_label_new (_("Display Format:"));
  gtk_widget_ref (pref_title_disp_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_disp_label", pref_title_disp_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_disp_label);
  gtk_box_pack_start (GTK_BOX (pref_title_disp_hbox), pref_title_disp_label, FALSE, FALSE, 0);

  pref_title_disp_entry = gtk_entry_new ();
  gtk_widget_ref (pref_title_disp_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_disp_entry", pref_title_disp_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_disp_entry);
  gtk_box_pack_start (GTK_BOX (pref_title_disp_hbox), pref_title_disp_entry, TRUE, TRUE, 0);

  pref_title_hsep = gtk_hseparator_new ();
  gtk_widget_ref (pref_title_hsep);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_hsep", pref_title_hsep,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_hsep);
  gtk_box_pack_start (GTK_BOX (pref_title_vbox), pref_title_hsep, TRUE, TRUE, 0);

  pref_title_desc_hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (pref_title_desc_hbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_desc_hbox", pref_title_desc_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_desc_hbox);
  gtk_box_pack_start (GTK_BOX (pref_title_vbox), pref_title_desc_hbox, TRUE, TRUE, 0);

  pref_title_desc1_label = gtk_label_new (_("%1 Artist\n%2 Title\n%3 Album"));
  gtk_widget_ref (pref_title_desc1_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_desc1_label", pref_title_desc1_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_desc1_label);
  gtk_box_pack_start (GTK_BOX (pref_title_desc_hbox), pref_title_desc1_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (pref_title_desc1_label), GTK_JUSTIFY_LEFT);

  pref_title_desc2_label = gtk_label_new (_("%4 Year\n%5 Comment\n%6 Genre"));
  gtk_widget_ref (pref_title_desc2_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_desc2_label", pref_title_desc2_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_desc2_label);
  gtk_box_pack_start (GTK_BOX (pref_title_desc_hbox), pref_title_desc2_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (pref_title_desc2_label), GTK_JUSTIFY_LEFT);

  pref_title_desc3_label = gtk_label_new (_("%7 File name\n%8 File extension\n%9 File path"));
  gtk_widget_ref (pref_title_desc3_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_desc3_label", pref_title_desc3_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_desc3_label);
  gtk_box_pack_start (GTK_BOX (pref_title_desc_hbox), pref_title_desc3_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (pref_title_desc3_label), GTK_JUSTIFY_LEFT);

  pref_title_page = gtk_label_new (_("Title"));
  gtk_widget_ref (pref_title_page);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_title_page", pref_title_page,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_title_page);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_nb), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_nb), 2), pref_title_page);

  pref_hbbox = gtk_hbutton_box_new ();
  gtk_widget_ref (pref_hbbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_hbbox", pref_hbbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_hbbox);
  gtk_box_pack_start (GTK_BOX (pref_vbox), pref_hbbox, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pref_hbbox), 5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (pref_hbbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (pref_hbbox), 10);

  pref_ok = gtk_button_new_with_label (_("Ok"));
  gtk_widget_ref (pref_ok);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_ok", pref_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_ok);
  gtk_container_add (GTK_CONTAINER (pref_hbbox), pref_ok);
  GTK_WIDGET_SET_FLAGS (pref_ok, GTK_CAN_DEFAULT);

  pref_cancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (pref_cancel);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_pref_window), "pref_cancel", pref_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pref_cancel);
  gtk_container_add (GTK_CONTAINER (pref_hbbox), pref_cancel);
  GTK_WIDGET_SET_FLAGS (pref_cancel, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (pref_title_disable_check), "released",
                      GTK_SIGNAL_FUNC (on_pref_title_disable_check_released),
                      NULL);
  gtk_signal_connect_object (GTK_OBJECT (pref_ok), "clicked",
                             GTK_SIGNAL_FUNC (on_mpg123_pref_ok_clicked),
                             GTK_OBJECT (mpg123_pref_window));
  gtk_signal_connect_object (GTK_OBJECT (pref_cancel), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (mpg123_pref_window));

  return mpg123_pref_window;
}

GtkWidget*
create_mpg123_info_window (void)
{
  GtkWidget *mpg123_info_window;
  GtkWidget *info_vbox_main;
  GtkWidget *info_filename_frame;
  GtkWidget *info_filename_entry;
  GtkWidget *info_hbox;
  GtkWidget *info_mpeg_frame;
  GtkWidget *info_mpeg_label;
  GtkWidget *info_vbox;
  GtkWidget *info_id3tag_frame;
  GtkWidget *info_id3tag_vbox;
  GtkWidget *info_id3tag_table;
  GtkWidget *info_id3tag_album_label;
  GtkWidget *info_id3tag_title_label;
  GtkWidget *info_id3tag_artist_label;
  GtkWidget *info_id3tag_comment_label;
  GtkWidget *info_id3tag_year_label;
  GtkWidget *info_id3tag_year_entry;
  GtkWidget *info_id3tag_genre_label;
  GtkWidget *info_id3tag_album_entry;
  GtkWidget *info_id3tag_comment_entry;
  GtkWidget *info_id3tag_artist_entry;
  GtkWidget *info_id3tag_title_entry;
  GtkWidget *info_id3tag_genre_combo;
  GtkWidget *info_id3tag_genre_combo_entry;
  GtkWidget *info_hbuttonbox;
  GtkWidget *info_cancel;
  GtkWidget *info_save;
  GtkWidget *info_remove;

  mpg123_info_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mpg123_info_window), "mpg123_info_window", mpg123_info_window);
  gtk_window_set_title (GTK_WINDOW (mpg123_info_window), _("mpg123 File Info"));

  info_vbox_main = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (info_vbox_main);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_vbox_main", info_vbox_main,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_vbox_main);
  gtk_container_add (GTK_CONTAINER (mpg123_info_window), info_vbox_main);

  info_filename_frame = gtk_frame_new (_("Filename"));
  gtk_widget_ref (info_filename_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_filename_frame", info_filename_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_filename_frame);
  gtk_box_pack_start (GTK_BOX (info_vbox_main), info_filename_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (info_filename_frame), 5);

  info_filename_entry = gtk_entry_new ();
  gtk_widget_ref (info_filename_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_filename_entry", info_filename_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_filename_entry);
  gtk_container_add (GTK_CONTAINER (info_filename_frame), info_filename_entry);
  gtk_entry_set_editable (GTK_ENTRY (info_filename_entry), FALSE);

  info_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (info_hbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_hbox", info_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_hbox);
  gtk_box_pack_start (GTK_BOX (info_vbox_main), info_hbox, TRUE, TRUE, 0);

  info_mpeg_frame = gtk_frame_new (_("MPEG Info"));
  gtk_widget_ref (info_mpeg_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_mpeg_frame", info_mpeg_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_mpeg_frame);
  gtk_box_pack_start (GTK_BOX (info_hbox), info_mpeg_frame, FALSE, TRUE, 0);
  gtk_widget_set_usize (info_mpeg_frame, 140, -2);
  gtk_container_set_border_width (GTK_CONTAINER (info_mpeg_frame), 5);

  info_mpeg_label = gtk_label_new ("");
  gtk_widget_ref (info_mpeg_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_mpeg_label", info_mpeg_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_mpeg_label);
  gtk_container_add (GTK_CONTAINER (info_mpeg_frame), info_mpeg_label);
  gtk_label_set_justify (GTK_LABEL (info_mpeg_label), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_padding (GTK_MISC (info_mpeg_label), 5, 5);

  info_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (info_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_vbox", info_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_vbox);
  gtk_box_pack_start (GTK_BOX (info_hbox), info_vbox, TRUE, TRUE, 0);
  gtk_widget_set_usize (info_vbox, 350, -2);

  info_id3tag_frame = gtk_frame_new (_("ID3 Tag"));
  gtk_widget_ref (info_id3tag_frame);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_frame", info_id3tag_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_frame);
  gtk_box_pack_start (GTK_BOX (info_vbox), info_id3tag_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (info_id3tag_frame), 5);

  info_id3tag_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (info_id3tag_vbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_vbox", info_id3tag_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_vbox);
  gtk_container_add (GTK_CONTAINER (info_id3tag_frame), info_id3tag_vbox);

  info_id3tag_table = gtk_table_new (5, 4, FALSE);
  gtk_widget_ref (info_id3tag_table);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_table", info_id3tag_table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_table);
  gtk_box_pack_start (GTK_BOX (info_id3tag_vbox), info_id3tag_table, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (info_id3tag_table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (info_id3tag_table), 10);
  gtk_table_set_col_spacings (GTK_TABLE (info_id3tag_table), 5);

  info_id3tag_album_label = gtk_label_new (_("Album:"));
  gtk_widget_ref (info_id3tag_album_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_album_label", info_id3tag_album_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_album_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_album_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_album_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_title_label = gtk_label_new (_("Title:"));
  gtk_widget_ref (info_id3tag_title_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_title_label", info_id3tag_title_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_title_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_title_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_title_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_artist_label = gtk_label_new (_("Artist:"));
  gtk_widget_ref (info_id3tag_artist_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_artist_label", info_id3tag_artist_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_artist_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_artist_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_artist_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_comment_label = gtk_label_new (_("Comment:"));
  gtk_widget_ref (info_id3tag_comment_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_comment_label", info_id3tag_comment_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_comment_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_comment_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_comment_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_year_label = gtk_label_new (_("Year:"));
  gtk_widget_ref (info_id3tag_year_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_year_label", info_id3tag_year_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_year_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_year_label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_year_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_year_entry = gtk_entry_new_with_max_length (4);
  gtk_widget_ref (info_id3tag_year_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_year_entry", info_id3tag_year_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_year_entry);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_year_entry, 1, 2, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (info_id3tag_year_entry, 50, -2);

  info_id3tag_genre_label = gtk_label_new (_("Genre:"));
  gtk_widget_ref (info_id3tag_genre_label);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_genre_label", info_id3tag_genre_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_genre_label);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_genre_label, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (info_id3tag_genre_label), GTK_JUSTIFY_RIGHT);

  info_id3tag_album_entry = gtk_entry_new_with_max_length (30);
  gtk_widget_ref (info_id3tag_album_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_album_entry", info_id3tag_album_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_album_entry);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_album_entry, 1, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  info_id3tag_comment_entry = gtk_entry_new_with_max_length (30);
  gtk_widget_ref (info_id3tag_comment_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_comment_entry", info_id3tag_comment_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_comment_entry);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_comment_entry, 1, 4, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  info_id3tag_artist_entry = gtk_entry_new_with_max_length (30);
  gtk_widget_ref (info_id3tag_artist_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_artist_entry", info_id3tag_artist_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_artist_entry);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_artist_entry, 1, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  info_id3tag_title_entry = gtk_entry_new_with_max_length (30);
  gtk_widget_ref (info_id3tag_title_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_title_entry", info_id3tag_title_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_title_entry);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_title_entry, 1, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  info_id3tag_genre_combo = gtk_combo_new ();
  gtk_widget_ref (info_id3tag_genre_combo);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_genre_combo", info_id3tag_genre_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_genre_combo);
  gtk_table_attach (GTK_TABLE (info_id3tag_table), info_id3tag_genre_combo, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  info_id3tag_genre_combo_entry = GTK_COMBO (info_id3tag_genre_combo)->entry;
  gtk_widget_ref (info_id3tag_genre_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_id3tag_genre_combo_entry", info_id3tag_genre_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_id3tag_genre_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (info_id3tag_genre_combo_entry), FALSE);

  info_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_ref (info_hbuttonbox);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_hbuttonbox", info_hbuttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (info_vbox), info_hbuttonbox, TRUE, TRUE, 0);

  info_cancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (info_cancel);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_cancel", info_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_cancel);
  gtk_container_add (GTK_CONTAINER (info_hbuttonbox), info_cancel);
  GTK_WIDGET_SET_FLAGS (info_cancel, GTK_CAN_DEFAULT);

  info_save = gtk_button_new_with_label (_("Save"));
  gtk_widget_ref (info_save);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_save", info_save,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_save);
  gtk_container_add (GTK_CONTAINER (info_hbuttonbox), info_save);
  GTK_WIDGET_SET_FLAGS (info_save, GTK_CAN_DEFAULT);

  info_remove = gtk_button_new_with_label (_("Remove"));
  gtk_widget_ref (info_remove);
  gtk_object_set_data_full (GTK_OBJECT (mpg123_info_window), "info_remove", info_remove,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (info_remove);
  gtk_container_add (GTK_CONTAINER (info_hbuttonbox), info_remove);
  GTK_WIDGET_SET_FLAGS (info_remove, GTK_CAN_DEFAULT);

  gtk_signal_connect_object (GTK_OBJECT (info_cancel), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (mpg123_info_window));
  gtk_signal_connect_object (GTK_OBJECT (info_save), "clicked",
                             GTK_SIGNAL_FUNC (on_info_save_clicked),
                             GTK_OBJECT (mpg123_info_window));
  gtk_signal_connect_object (GTK_OBJECT (info_remove), "clicked",
                             GTK_SIGNAL_FUNC (on_info_remove_clicked),
                             GTK_OBJECT (mpg123_info_window));

  return mpg123_info_window;
}

