/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include "id3v1.h"


/*
 * Data
 */

char *tab_genre[] =
{
    "Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge","Hip-Hop",
    "Jazz","Metal","New Age","Oldies","Other","Pop","R&B","Rap","Reggae",
    "Rock","Techno","Industrial","Alternative","Ska","Death Metal","Pranks",
    "Soundtrack","Euro-Techno","Ambient","Trip-Hop","Vocal","Jazz+Funk",
    "Fusion","Trance","Classical","Instrumental","Acid","House","Game",
    "Sound Clip","Gospel","Noise","Alt. Rock","Bass","Soul","Punk","Space",
    "Meditative","Instrumental Pop","Instrumental Rock","Ethnic","Gothic",
    "Darkwave","Techno-Industrial","Electronic","Pop-Folk","Eurodance","Dream",
    "Southern Rock","Comedy","Cult","Gangsta Rap","Top 40","Christian Rap",
    "Pop/Funk","Jungle","Native American","Cabaret","New Wave","Psychedelic",
    "Rave","Showtunes","Trailer","Lo-Fi","Tribal","Acid Punk","Acid Jazz",
    "Polka","Retro","Musical","Rock & Roll","Hard Rock","Folk","Folk/Rock",
    "National Folk","Swing","Fast-Fusion","Bebob","Latin","Revival","Celtic",
    "Bluegrass","Avantgarde","Gothic Rock","Progressive Rock",
    "Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band","Chorus",
    "Easy Listening","Acoustic","Humour","Speech","Chanson","Opera",
    "Chamber Music","Sonata","Symphony","Booty Bass","Primus","Porn Groove",
    "Satire","Slow Jam","Club","Tango","Samba","Folklore","Ballad",
    "Power Ballad","Rhythmic Soul","Freestyle","Duet","Punk Rock","Drum Solo",
    "A Cappella","Euro-House","Dance Hall","Goa","Drum & Bass","Club-House",
    "Hardcore","Terror","Indie","BritPop","Negerpunk","Polsk Punk","Beat",
    "Christian Gangsta Rap","Heavy Metal","Black Metal","Crossover",
    "Contemporary Christian","Christian Rock","Merengue","Salsa",
    "Thrash Metal","Anime","JPop","Synthpop","", NULL
};

/*
 * Prototypes
 */

static void remove_spaces( char *string );

/*
 * Read ID3v1 Tag
 */

int id3v1tag_read( char *filename, ID3v1tag *id3v1tag )
{
  FILE *stream;
  char tmp[4];

  if(( stream = fopen( filename, "rb" )) == NULL )	return 0;

  fseek( stream, -128, SEEK_END );

  fread( tmp, 1, 3, stream );
  if( strncmp( tmp, "TAG", 3 ))
  {
	fclose( stream );
	return 0;
  }

  fread( id3v1tag->Title, 1, 30, stream );
  id3v1tag->Title[30] = '\0';
  fread( id3v1tag->Artist, 1, 30, stream );
  id3v1tag->Artist[30] = '\0';
  fread( id3v1tag->Album, 1, 30, stream );
  id3v1tag->Album[30] = '\0';
  fread( id3v1tag->Year, 1, 4, stream );
  id3v1tag->Year[4] = '\0';
  fread( id3v1tag->Comment, 1, 30, stream );
  id3v1tag->Comment[30] = '\0';

  fread( &id3v1tag->Genre, 1, 1, stream );

  remove_spaces( id3v1tag->Title );
  remove_spaces( id3v1tag->Artist );
  remove_spaces( id3v1tag->Album );
  remove_spaces( id3v1tag->Year );
  remove_spaces( id3v1tag->Comment );

  fclose( stream );
  return 1;
}

/*
 * Save ID3v1 tag
 */

int id3v1tag_save( char *filename, ID3v1tag *id3v1tag )
{
  int stream;
  char tmp[4];

  if(( stream = open( filename, O_RDWR )) == -1 )	return 0;

  lseek( stream, -128, SEEK_END );
  read( stream, tmp, 3 );

  if( strncmp( tmp, "TAG", 3 ))	lseek( stream, 0, SEEK_END );
  else	lseek( stream, -128, SEEK_END );

  write( stream, "TAG", 3 );
  write( stream, id3v1tag->Title, 30 );
  write( stream, id3v1tag->Artist, 30 );
  write( stream, id3v1tag->Album, 30 );
  write( stream, id3v1tag->Year, 4 );
  write( stream, id3v1tag->Comment, 30 );
  write( stream, &id3v1tag->Genre, 1 );

  close( stream );
  return 1;
}

/*
 * Remove ID3 Tag
 */

int id3v1tag_remove( char *filename )
{
  int	fd, len;
  char	buf[4];

  if(( fd = open( filename, O_RDWR )) != -1 )
  {
	len = lseek( fd, -128, SEEK_END );
	read( fd, buf, 3 );

	if( !strncmp( buf, "TAG", 3 ))	ftruncate( fd, len );

	close(fd);
  }

  return 0;
}

/*
 * Internal
 */

static void remove_spaces( char *string )
{
  int pos = strlen( string ) - 1;

  while(( pos > - 1 ) && ( string[pos] == ' ' ))	string[pos--] = '\0';
}
