/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_id3v1_h
#define INC_id3v1_h

/*
 * Types
 */

typedef struct _id3v1tag
{
    char		Title[31];
    char		Artist[31];
    char		Album[31];
    char		Year[5];
    char		Comment[31];
    unsigned char	Track;
    unsigned char	Genre;
} ID3v1tag;

/*
 * Data
 */

extern char *tab_genre[];

/*
 * Prototypes
 */

int id3v1tag_read( char *filename, ID3v1tag *id3v1tag );
int id3v1tag_save( char *filename, ID3v1tag *id3v1tag );
int id3v1tag_remove( char *filename );

#endif
