/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Private code
 */

#include "mpglib/mpg123.h"
#include "mpglib/mpglib.h"
#include "libmpg123_info.h"

/*
 * This code is taken from my old mpg123 code ( libmpg123.c )
 */

/*
 * Tables
 */

static int	tab_bitrate[2][16][3] =
{
 { /* MPEG 1 */
  { 0, 0, 0 }, { 32, 32, 32 }, { 64, 48, 40 }, { 96, 56, 48 },
  { 128, 64, 56 }, { 160, 80, 64 }, { 192, 96, 80 }, { 224, 112, 96 },
  { 256, 128, 112 }, { 288, 160, 128 }, { 320, 192, 160 }, { 352, 224, 192 },
  { 384, 256, 224 }, { 416, 320, 256 }, { 448, 384, 320 }, { -1, -1, -1 }
 },
 { /* MPEG 2 */
  { 0, 0, 0 }, { 32,  8,  8 }, { 48, 16, 16 }, { 56, 24, 24 },
  { 64, 32, 32 }, { 80, 40, 40 }, { 96, 48, 48 }, { 112, 56, 56 },
  { 128, 64, 64 }, { 144, 80, 80 }, { 160, 96, 96 }, { 176,112,112 },
  { 192, 128, 128 }, { 224, 144, 144 }, { 256, 160, 160 }, { -1, -1, -1 }
 }
};

#if 0
static char	*tab_mode[4] = { "Stereo", "Joint-Stereo", "Dual-Channel", "Single-Channel" };
#endif

static long	tab_freq[9] = { 44100, 48000, 32000, 22050, 24000, 16000 , 11025 , 12000 , 8000 };

static int	tab_bs[4] = { 0, 384, 1152, 1152 };

/*
 * Compute bytes per frame
 */

static double compute_bpf( struct frame *fr )
{
  double bpf = 0.0;

  switch( fr->lay )
  {
    case 1:
	bpf = 48000 * (double)tab_bitrate[fr->lsf][fr->bitrate_index][0] / ( tab_freq[fr->sampling_frequency] << fr->lsf );
	break;
    case 2:
    case 3:
	bpf = 144000 * (double)tab_bitrate[fr->lsf][fr->bitrate_index][fr->lay - 1] / ( tab_freq[fr->sampling_frequency] << fr->lsf );
	break;
  }

  return bpf;
}

/*
 * Compute time per frame
 */

static double compute_tpf( struct frame *fr )
{
  return (double)tab_bs[fr->lay] / ( tab_freq[fr->sampling_frequency] << fr->lsf );
}

int MPG123_GetInfo( struct mpstr *mp, MPG123_Info *mpg123_info )
{
  mpg123_info->bpf 	= compute_bpf( &mp->fr );
  mpg123_info->tpf 	= compute_tpf( &mp->fr );

  mpg123_info->bitRate	= tab_bitrate[mp->fr.lsf][mp->fr.bitrate_index][mp->fr.lay - 1];

  mpg123_info->sampRate	= tab_freq[mp->fr.sampling_frequency];
  mpg123_info->sampSize	= 16;
  mpg123_info->channels = mp->fr.stereo;

  mpg123_info->mpeg	= mp->fr.mpeg25 ? 3 : mp->fr.lsf;
  mpg123_info->layer	= mp->fr.lay;
  mpg123_info->crc	= mp->fr.error_protection;
  mpg123_info->mode	= mp->fr.mode;
  mpg123_info->copyright= mp->fr.copyright;
  mpg123_info->original	= mp->fr.original;
  mpg123_info->emphasis	= mp->fr.emphasis;

  return 1;
}
