/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libmpg123_info_h
#define INC_libmpg123_info_h

/*
 * Info struct
 */

typedef struct _mpg123_info
{
    /* Calculated stuff */
    unsigned long	bitRate;
    unsigned long	sampRate;
    unsigned long	sampSize;
    unsigned long	channels;

    double		bpf, tpf;

    /* System */
    unsigned long	mpeg;
    unsigned long	layer;

    /* Flags */
    unsigned short	mode;
    unsigned short	crc;
    unsigned short	copyright;
    unsigned short	original;

    /* Other */
    unsigned long	emphasis;
} MPG123_Info;

/*
 * Prototypes
 */

int MPG123_GetInfo( struct mpstr *mp, MPG123_Info *mpg123_info );

#endif
