/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mpglib/mpg123.h"
#include "mpglib/mpglib.h"
#include "libmpg123_vbr.h"

/*
 * Definitions
 */

/*
 * Global data
 */

static int	table_TagOffset[2][2] =
{
    { 17, 32 },		/* MPEG 1 ( Mono / Stereo ) */
    {  9, 17 }		/* MPEG 2 ( Mono / Stereo ) */
};

static char	VBRTagID[] = { 'X', 'i', 'n', 'g' };

/*
 * Prototypes
 */

static unsigned long get32bits( unsigned char *buffer );

/*
 * Get VBR Header
 */

int MPG123_GetVBRHeader( struct mpstr *mp, char *buffer, VBRHeader *head )
{
  /* Get offset */
  buffer += ( table_TagOffset[ mp->fr.lsf ][ mp->fr.stereo - 1 ] + 4 );

  /* Has VBR Tag ? */
  if(( buffer[0] != VBRTagID[0] ) || ( buffer[1] != VBRTagID[1] ) ||
	( buffer[2] != VBRTagID[2] ) || ( buffer[3] != VBRTagID[3] ))
		return 0;
  buffer += 4;

  /* Get VBR header flags */
  head->flags = get32bits( buffer );
  buffer += 4;

  /* Get frame number */
  if( head->flags & VBR_FLAG_FRAMES )
  {
	head->frames = get32bits( buffer );
	buffer += 4;
  }

  /* Get byte number */
  if( head->flags & VBR_FLAG_BYTES )
  {
	head->bytes = get32bits( buffer ); 
	buffer += 4;
  }

  /* Get table of contents */
  if( head->flags & VBR_FLAG_TOC )
  {
	memcpy( head->toc, buffer, 100 );
	buffer += 100;
  }

  /* Get scale ( VBR quality: (0) best (100) worst */
  if( head->flags & VBR_FLAG_SCALE )
  {
	head->scale = get32bits( buffer );
	buffer += 4;
  }

  return 1;
}

/*
 * Private code
 */

static unsigned long get32bits( unsigned char *buffer )
{
  return (((unsigned long) buffer[0] ) << 24 ) |
	(((unsigned long) buffer[1] ) << 16 ) |
	(((unsigned long) buffer[2] ) << 8 ) |
	((unsigned long) buffer[3] );
}
