/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libmpg123_vbr_h
#define INC_libmpg123_vbr_h

/*
 * Definitions
 */

#define VBR_TOC_ENTRIES		100

/*
 * Flags
 */

#define VBR_FLAG_FRAMES		0x0001
#define VBR_FLAG_BYTES		0x0002
#define VBR_FLAG_TOC		0x0004
#define VBR_FLAG_SCALE		0x0008

/*
 * VBR Header
 */

typedef struct VBRHeader_s
{
	unsigned long flags;
	unsigned long frames;
	unsigned long bytes;
	unsigned long scale;
	unsigned char toc[VBR_TOC_ENTRIES];
} VBRHeader;

/*
 * Prototypes
 */

int MPG123_GetVBRHeader( struct mpstr *mp, char *buffer, VBRHeader *head );

#endif
