/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_wave_h
#define INC_wave_h

#include <inttypes.h>

/*
 * Riff chunk definitions
 */

#define	RIFF_ID_RIFF	0x46464952	/* 'RIFF' */
#define	RIFF_ID_WAVE	0x45564157	/* 'WAVE' */
#define RIFF_ID_fmt	0x20746D66	/* 'fmt ' */
#define	RIFF_ID_data	0x61746164	/* 'data' */

/*
 * Wave format header
 */

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_

typedef struct _WAVEFORMATEX
{
    uint16_t	wFormatTag;		/* Format */
    uint16_t	nChannels;		/* Channels */
    uint32_t	nSamplesPerSec;		/* Rate */
    uint32_t	nAvgBytesPerSec;	/* Average bytes / sec */
    uint16_t	nBlockAlign;		/* block size of data */
    uint16_t	wBitsPerSample;		/* Number of bits per sample */

    /* if wFormatTag != WAVE_FORMAT_PCM */
    uint16_t	cbSize;			/* Size of extra data */
} WAVEFORMATEX;

#endif

#endif
