/*
 * decode_mm.c
 * Accelarated decoding, by Arthur Kleer 01.10.2001
 * Based on decode_i386.c ( mpg123 )
 */

#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "mpg123.h"
#include "mpglib.h"

/*
 * Synth functions
 */

#ifdef PENTIUM_OPT

/* defined in decode_i586.s */
int synth_1to1_pent (real *,int,unsigned char *);

/*
 * Pentium accelaration
 * Origin: mpg123 CVS decode_i386.c, synth_1to1()
 */

int _synth_1to1_pent(real *bandPtr,int channel,unsigned char *out,int *pnt)
{
    int ret;
    ret = synth_1to1_pent(bandPtr,channel,out+*pnt);
    *pnt += 128;
    return ret;
}

#endif

#ifdef USE_MMX

/* defined in decode_MMX.s */
int synth_1to1_MMX(real *, int, short *, short *, int *);

/*
 * MMX accelaration
 * Origin: mpg123 CVS decode_i386.c, synth_1to1()
 */

int _synth_1to1_MMX(real *bandPtr,int channel,unsigned char *out,int *pnt)
{
    static short buffs[2][2][0x110];
    static int bo = 1;
    short *samples = (short *) (out + *pnt);
    synth_1to1_MMX(bandPtr, channel, samples, (short *) buffs, &bo); 
    *pnt += 128;
    return 0;
}

#endif
