/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libmpg123_h
#define INC_libmpg123_h

#include <inttypes.h>
#include "mpg123.h"
#include "mpglib.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Definitions
 */

#define	MPG123_OK			0
#define	MPG123_ERROR			-1
#define	MPG123_MOREDATA			-2

/*
 * Flags ( for accelaration )
 */

	/** Bits containing CPU info */
#define	MMACCEL_CPUMASK			0xF0000000
	/** Shift for CPU info */
#define	MMACCEL_CPUSHIFT		28

	/** Intel MMX and compatible. */
#define MMACCEL_X86_MMX			0x0001

	/** Pentium ( and clones ) */
#define	MMACCEL_CPU_586			( 5 << MMACCEL_CPUSHIFT )
	/* Pentium II ( and clones ) */
#define	MMACCEL_CPU_686			( 6 << MMACCEL_CPUSHIFT )

/*
 * Types
 */

typedef int (*reader_read_t)( void *priv, void *data, int size );

typedef struct
{
    int		(*read)( void *priv, void *data, int size );
    int		(*size)( void *priv );
} mpg123_reader_t;

typedef struct mpstr mpg123_t;


/*
 * Prototypes
 */

	/*
	 * Initialize libmpg123
	 */
int	MPG123_Init( mpg123_t *mpg123, uint32_t flags );

	/*
	 * Free libmp123
	 */
void	MPG123_Exit( mpg123_t *mpg123 );

	/*
	 * Decode one frame
	 */
int	MPG123_DecodeFrame( mpg123_t *mpg123, unsigned char *out, int *done, mpg123_reader_t *reader, void *priv );

#ifdef __cplusplus
}
#endif

#endif
