/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * dotest.c
 *
 * Demonstrates:
 *  - the use of direct out mode of input plugins
 *
 * Uses:
 *  - libxmm		- LinuX MultiMedia Library
 *
 * Usage:
 *  dotest <filename>
 */

/* Change 'undef' in 'define' to get debug info */
#ifndef DEBUG
#undef	DEBUG
#endif

/*
 * Includes
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <libxmm/libxmm.h>
#include <libxmm/util/utils.h>

/*
 * Sound plugin, that should be used
 */

#define SOUND_PLUGIN LIBDIR "Plugins/Sound/oss.so"

/*
 * main()
 */

int main( int argc, char *argv[] )
{
  void			*xmm;
  XMM_PluginInput	*pInput;

  /* Initialize libxmm */  
  if(( xmm = xmm_Init()) == NULL )
  {
	fprintf( stderr, "ERROR: %s\n", xmm_ErrorString( xmm ));
	return 1;
  }

  /* Set output plugins */  
  if( xmm_AcSoundPluginName( XMMPLAY_2XMM(xmmplay), SOUND_PLUGIN ) == NULL )
  {
	printf( "\nError setting output plugins: %s\n", xmm_ErrorString( XMMPLAY_2XMM( xmmplay )));
	exit(1);
  }

  /* Open file */
  if(( pInput = xmm_InputOpen( xmm, argv[1], XMM_INPUT_CF_MODE_DOUT )) == NULL )
  {
	fprintf( stderr, "ERROR: %s\n", xmm_ErrorString( xmm ));
	xmm_Exit( xmm );
	return 1;
  }

  /* Start playback */
  if( xmm_InputControl( pInput, XMM_CTLINP_PLAY, 0, NULL ) != XMM_CTLRET_TRUE )
  {
	fprintf( stderr, "ERROR: %s\n", xmm_ErrorString( xmm ));
	xmm_InputClose( pInput );
	xmm_Exit( xmm );
	return 1;
  }

  sleep(5);

  /* Stop playback */
  if( xmm_InputControl( pInput, XMM_CTLINP_STOP, 0, NULL ) != XMM_CTLRET_TRUE )
  {
	fprintf( stderr, "ERROR: %s\n", xmm_ErrorString( xmm ));
	xmm_InputClose( pInput );
	xmm_Exit( xmm );
	return 1;
  }

  /* Close input */
  xmm_InputClose( pInput );

  /* Free libxmm */
  xmm_Exit( xmm );

  return 0;
}
