/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * Global data
 */

extern char	*win32_codec_name;
extern char	*win32_def_path;

/*
 * Set codec DLL
 */
void SetCodecDLL( const char *filename )
{
  if( win32_codec_name )	free( win32_codec_name );
  win32_codec_name = strdup( filename );
}

/*
 * Set codec DLL path
 */
void SetCodecPath( const char *path )
{
  static int dynamic = 0;

  /* Free allocated memory */
  if( dynamic )	free( win32_def_path );

  win32_def_path = strdup( path );
  dynamic = 1;
}
