/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_error_h
#define INC_libxmm_error_h

/** @file error.h
 * Linux MultiMedia Project: error system
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Prototypes
 */

	/**
	 * Set error.
	 * Set error ( code, string ) for specified XMM object. An error
	 * description will be build using internal information on error
	 * number and the text constructed from format and following arguments.
	 *
	 * \param xmm XMM object
	 * \param error error code. One of the #XMM_RET_ constants.
	 * \param format error description. '\n' not desired at end of string.
	 * format is followed by a variable number of arguments.
	 *
	 * \return -error is returned.
	 */
int	xmm_SetError( void *xmm, int error, const char *format,... );

	/**
	 * Get error code.
	 * Get error code of last error.
	 *
	 * \param xmm XMM object
	 *
	 * \return Last error code will be retuned.
	 */
int	xmm_Error( void *xmm );

	/**
	 * Get error string.
	 * Get error string of last error.
	 *
	 * \param xmm XMM object
	 *
	 * \return Pointer to last error description is retuned.
	 */
const char *xmm_ErrorString( void *xmm );

#ifdef __cplusplus
}
#endif

#endif
