/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_libxmm_h
#define INC_libxmm_libxmm_h

/** @file libxmm.h
 * Linux MultiMedia Project: API and library
 */

#include <libxmm/xmmp.h>
#include <libxmm/version.h>
#include <libxmm/xmmctl.h>
#include <libxmm/error.h>
#include <libxmm/event.h>
#include <libxmm/event_ksym.h>
#include <libxmm/achain.h>
#include <libxmm/lpcodecv.h>
#include <libxmm/lpfilterv.h>
#include <libxmm/lpgraph.h>
#include <libxmm/lpinput.h>
#include <libxmm/lpio.h>
#include <libxmm/lpoutput.h>
#include <libxmm/config.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Prototypes
 */

	/**
	 * Init.
	 * Init LinuX MultiMedia Project.
	 *
         * \return Upon successful completion a XMMP object is returned.
         * Otherwise NULL.
	 */
void	*xmm_Init( void );

	/**
	 * Exit.
	 * Free all resources used by the LinuX MultiMedia Project.	 
	 */
void	xmm_Exit( void *_xmm );

#ifdef __cplusplus
}
#endif

#endif
