/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_bitstream_h
#define INC_libxmm_util_bitstream_h

/** @file bitstream.h
 * Linux MultiMedia Project: Bitstream
 */

#include <inttypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Definitions
 */

/*
 * Types
 */

/**
 * Bitstream.
 * Bitstream data type. This object represents a bitstream.
 */

typedef struct xmm_BitStream_s
{
    uint32_t		buffer;		/* Bit buffer, --> get max. 32 bits */
    int			bitindex;	/* Index in buffer */
    int			bitcount;	/* Total bits in buffer. ( n * 8, n >= 0 ) */
    uint8_t		*data;		/* Data pointer */
    int			size;		/* Data size */
} XMM_BitStream;

/*
 * Prototypes
 */

		/**
		 * Initialize bitstream.
		 * Used to initialize a bitstream from a data buffer.
		 * This function always has to be called, before any other
		 * bitstream function.
		 *
		 * \param bs bitstream
		 */
void		xmmBS_Init( XMM_BitStream *bs, uint8_t *data, int size );

		/**
		 * Get bits.
		 * Used to read some bits ( up to 32 ) from the bitstream.
		 *
		 * \param bs bitstream
		 * \param bits number of bits to read
		 *
		 * \return integer value of the read bits
		 */
uint32_t	xmmBS_Get( XMM_BitStream *bs, int bits );

		/**
		 * Get bits without removing them.
		 * Used to read some bits ( up to 32 ) from the bitstream.
		 *
		 * \param bs bitstream
		 * \param bits number of bits to read
		 *
		 * \return integer value of the read bits
		 */
uint32_t	xmmBS_Next( XMM_BitStream *bs, int bits );

#ifdef __cplusplus
}
#endif

#endif
