/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_system_h
#define INC_libxmm_util_system_h

/** @file utils.h
 * Linux MultiMedia Project: system dependent functions
 */

#include <inttypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

		/**
		 * Sleep.
		 * Suspends execution of the calling process.
		 *
		 * \param usecs Suspend time in microseconds
		 */
void		xmmSYS_usleep( uint32_t usecs );

		/**
		 * Access.
		 * Check user's permissions for a file.
		 *
		 * \param path File ( or other file system object )
		 * \param mode Mask
		 *
		 * \return Upon successful completion 1 is returned, if
		 * desired access is possible, 0 if not.
		 * Otherwise an error code ( negative value ).
		 */
int		xmmSYS_access( const char *path, int mode );

		/**
		 * Get number of ticks.
		 * This function returns the number of ticks (processor cycles)
		 * since power-on.
		 *
		 * \return Number of ticks
		 *
		 * \note The number of ticks returned by this call will
		 * start very fast at zero again. You if you need ticks
		 * over a longer period use xmmSYS_longcount()
		 */
extern uint32_t	(*xmmSYS_count)( void );

		/**
		 * Get number of ticks.
		 * This function returns the number of ticks (processor cycles)
		 * since power-on.
		 *
		 * \return Number of ticks
		 */
extern uint64_t	(*xmmSYS_longcount)( void );

#ifdef __cplusplus
}
#endif

#endif
