/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_libxmm_util_thread_h
#define INC_libxmm_util_thread_h

/** @file thread.h
 * Linux MultiMedia Project: Thread
 */

#include <inttypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Types
 */

/**
 * Thread.
 * LinuX MultiMedia Project Thread.
 */
struct XMM_Thread;
typedef	struct XMM_Thread XMM_Thread;

/*
 * Prototypes
 */

		/**
		 * Create.
		 * Create XMMP thread.
		 *
		 * \param fn Thread functions
		 * \param arg Argument, that will be passed to the thread function
		 *
		 * \return Upon successful completion the new XMMP Thread
		 * is returned. Otherwise NULL.
		 */
XMM_Thread	*xmmThread_Create( int (*fn)( void * ), void *arg );

		/**
		 * Wait.
		 * Wait for termination of a thread and free thread resources.
		 *
		 * \param thread thread object
		 *
		 * \return The return code of the thread function is retuned.
		 */
int		xmmThread_Wait( XMM_Thread *thread );

		/**
		 * Thread ID.
		 * Get thread identifier.
		 *
		 * \param thread thread object. If thread == NULL ID of the
		 * current thread is returned.
		 *
		 * \return The thread ID is returned.
		 */
uint32_t	xmmThread_ID( XMM_Thread *thread );

#ifdef __cplusplus
}
#endif

#endif
