/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * aformat.c
 * audio format
 */

#include <stdio.h>
#include "libxmm/aformat.h"

static char *acodec_table[] =
{
    "PCM (uncompressed)",
    "IEEE (uncompressed)",

    "CCITT G.711: u-Law",
    "CCITT G.711: A-Law",
    "CCITT G.721: %i-bit ADPCM",
    "CCITT G.723: %i-bit ADPCM",
    "CCITT G.726: %i-bit ADPCM",

    "MPEG Audio Layer 1/2/3",
    "AC3 / Dolby Digital",
    "GSM 6.10 (MS)",
    "Ogg/Vorbis",

    "DivX Audio ( WM-Audio V1 )",
    "DivX Audio ( WM-Audio V2 )",
    "MS ADPCM",
    "IMA ADPCM",
    "Voxware MetaSound"
};

void xmm_aformat_codec_desc( uint32_t format, char *string )
{
  switch( format & XMM_AUDIO_MASK_CODEC )
  {
	case XMM_AUDIO_CODEC_PCM:
		strcpy( string, acodec_table[0] );
		break;

	case XMM_AUDIO_CODEC_IEEE:
		strcpy( string, acodec_table[1] );
		break;

	case XMM_AUDIO_CODEC_ULAW:
		strcpy( string, acodec_table[2] );
		break;

	case XMM_AUDIO_CODEC_ALAW:
		strcpy( string, acodec_table[3] );
		break;

	case XMM_AUDIO_CODEC_G721:
		sprintf( string, acodec_table[4], format & XMM_AUDIO_MASK_SIZE );
		break;

	case XMM_AUDIO_CODEC_G723:
		sprintf( string, acodec_table[5], format & XMM_AUDIO_MASK_SIZE );
		break;

	case XMM_AUDIO_CODEC_G726:
		sprintf( string, acodec_table[6], format & XMM_AUDIO_MASK_SIZE );
		break;

	case XMM_AUDIO_CODEC_MPEG:
		strcpy( string, acodec_table[7] );
		break;

	case XMM_AUDIO_CODEC_AC3:
		strcpy( string, acodec_table[8] );
		break;

	case XMM_AUDIO_CODEC_GSM610MS:
		strcpy( string, acodec_table[9] );
		break;

	case XMM_AUDIO_CODEC_VORBIS:
		strcpy( string, acodec_table[10] );
		break;

	case XMM_AUDIO_CODEC_WMA1:
		strcpy( string, acodec_table[11] );
		break;

	case XMM_AUDIO_CODEC_WMA2:
		strcpy( string, acodec_table[12] );
		break;

	case XMM_AUDIO_CODEC_ADPCM_MS:
		strcpy( string, acodec_table[13] );
		break;

	case XMM_AUDIO_CODEC_ADPCM_IMA:
		strcpy( string, acodec_table[14] );
		break;

	case XMM_AUDIO_CODEC_VOX_META:
		strcpy( string, acodec_table[15] );
		break;

	default:
		break;
  }
}
