/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * error.c
 * Error handling
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "libxmm/error.h"
#include "../xmmpriv.h"
#include "error.h"

#include "libxmm/util/utils.h"

/*
 * Global Data
 */

static XMM_Error	global_xmm_error;

#if 0
#define	ERRPTR_DEF	XMM *errptr = (XMM *) _xmm;
#else
#define	ERRPTR_DEF	XMM_Error *errptr = &global_xmm_error;
#endif

/*
 * Set error
 */
int xmm_SetError( void *_xmm, int error, const char *format,... )
{
  ERRPTR_DEF
  va_list	ap;

  if( errptr == NULL )	return error;

  errptr->Errno = -error;

  if( xmm_error_string[errptr->Errno] )
  {
	sprintf( errptr->ErrDesc, "ERROR #%i (%s)", errptr->Errno, xmm_error_string[errptr->Errno] );
	if( format[0] != '\0' )	strcat( errptr->ErrDesc, ":\n" );
  }
  else	sprintf( errptr->ErrDesc, "ERROR #%i ", errptr->Errno );

  va_start( ap, format );
  vsprintf( errptr->ErrDesc + strlen( errptr->ErrDesc ), format, ap );
  va_end( ap );

  /* logging */
  xmm_logging( 1, "%s\n", errptr->ErrDesc );

  return error;
}

/*
 * Get error code.
 */
int xmm_Error( void *_xmm )
{
  ERRPTR_DEF

  return errptr->Errno;
}


/*
 * Get error string.
 */
const char *xmm_ErrorString( void *_xmm )
{
  ERRPTR_DEF

  return errptr->ErrDesc;
}
