/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * mm_accel.c
 * CPU multimedia extension support
 *
 * based on sse.h 
 * libsse-990416 by R. Fisher, Based on libxmm by H. Dietz and R. Fisher
 */

#include <stdio.h>
#include <inttypes.h>
#include "libxmm/util/mmaccel.h"
#include "config.h"

#include "libxmm/util/utils.h"

/*
 * Global data
 */

static uint32_t accel_mask = (uint32_t) -1;
static uint32_t	cpu_freq = (uint32_t) -1;

/*
 * Prototypes
 */

#ifdef HAVE_CPU_IX86
extern uint32_t accel_x86( uint32_t *cpu_freq );
#endif

/*
 * Get supported multimedia extensions
 */
uint32_t xmmCPU_mmsupport( void )
{
#ifdef HAVE_CPU_IX86
  static uint32_t x86accel = 0xFFFFFFFF;

  if( x86accel == 0xFFFFFFFF )	x86accel = accel_x86( &cpu_freq );

  return x86accel & accel_mask;
#else
  return 0 & accel_mask;
#endif
}

/*
 * Enable multimedia extension ( -1 will enable all )
 */
void xmmCPU_mmenable( uint32_t flags )
{
  accel_mask = flags;
}

/*
 * Query enabled multimedia extension
 */
uint32_t xmmCPU_mmenabled( void )
{
  return accel_mask;
}

/*
 * CPU clock ( Hz )
 */
uint32_t xmmCPU_clockfreq( void )
{
#ifdef HAVE_CPU_IX86
  if( cpu_freq == (uint32_t) -1 )	accel_x86( &cpu_freq );
#endif

  return cpu_freq;
}
