/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * thread.c
 * Thread implementation using pthread
 */

#include <stdlib.h>
#include <pthread.h>
#include "libxmm/xmmp.h"
#include "libxmm/error.h"
#include "libxmm/util/thread.h"
#include "libxmm/util/utils.h"

/*
 * Types
 */

typedef	void *(*pthread_fn)( void * );

/*
 * Create thread
 */
XMM_Thread *xmmThread_Create( int (*fn)( void * ), void *arg )
{
  pthread_t		*thread;

  /* Allocate */
  if(( thread = malloc( sizeof( pthread_t ))) == NULL )	return NULL;

  /* Start thread */
  pthread_create( thread, NULL, (pthread_fn) fn, arg );

  return (XMM_Thread *)thread;
}

/*
 * Wait for termination of a thread
 */
int xmmThread_Wait( XMM_Thread *thread )
{
  int ret;

  if( thread == NULL )	return XMM_RET_INVALID_ARG;

  pthread_join( *((pthread_t *) thread ), (void *) &ret );

  free( thread );
  return ret;
}

/*
 * Get thread ID
 */
uint32_t xmmThread_ID( XMM_Thread *thread )
{
  if( thread == NULL )	return (uint32_t) pthread_self();
  else	return (uint32_t) *((pthread_t *) thread );
}
