/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_wmv_h
#define INC_wmv_h

/*
 * Definitions
 */

#define	WMV_USE_VFW
#define	WMV_USE_DS

/* Change 'undef' in 'define' for verbose mode */
#ifndef VERBOSE
#undef	VERBOSE
#endif

/* Weed need at least one of (WMV_USE_VFW,WMV_USE_DS) */
#if !defined(WMV_USE_VFW) && !defined(WMV_USE_DS)
#error "No WMV decoder enabled"
#endif

/*
 * Types
 */

typedef struct decoder_s	decoder_t;

struct decoder_s
{
    int		(*Open)( void *xmm, decoder_t *decoder, XMM_VideoFormat *vf, int *yflip );
    int		(*Close)( void *xmm, decoder_t *decoder );
    int		(*QueryFormat)( void *xmm, decoder_t *decoder, uint32_t format );
    int		(*SetFormat)( void *xmm, decoder_t *decoder, uint32_t format );
    int		(*Decode)( void *xmm, decoder_t *decoder, uint8_t *src, int isize, uint8_t *dest[], int *osize, int *flags );
    void	*priv;
};

/*
 * Prototypes
 */

int wmv_decoder_init_vfw( void *xmm, decoder_t *decoder );
int wmv_decoder_init_ds( void *xmm, decoder_t *decoder );

#endif
