/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * null.c
 * Audio codec plugin: null. only copy data [decoding/encoding]
 */

#include <stdio.h>
#include <stdlib.h>

#include <libxmm/xmmp.h>
#include <libxmm/version.h>
#include <libxmm/xmmctl.h>
#include <libxmm/afilter.h>
#include <libxmm/error.h>
#include <libxmm/util/utils.h>

/*
 * Types
 */

struct priv_t
{
    XMM_AudioFormat		*daf;
};

/*
 * Filter info
 */

static XMM_FilterAudioInfo	null_fai =
{
    XMM_FILTER_ACF_DECODE | XMM_FILTER_ACF_ENCODE | XMM_FILTER_ACF_CODEC,
    "",					/* Filename. Will be initialized later */
    "NULL (copy)",			/* Name */
    "",					/* Description */
    "Copyright (c) 2002 Arthur Kleer",	/* Copyright */
    0,					/* Number of supported formats */
    NULL				/* Pointer to format data */
};

/*
 * Global data
 */

extern XMM_PluginFilterAudio	plugin_info;

/*
 * Initialize Plugin
 */
static XMM_PluginFilterAudio *null_Open( void *xmm, XMM_AudioFormat *saf, XMM_AudioFormat *daf, uint32_t flags )
{
  XMM_PluginFilterAudio	*pFilter;
  struct priv_t		*priv;
  int			ret = 0;

  /* Only query filter */
  if( flags & XMM_FILTER_AOF_QUERY )	ret = XMM_RET_NOTSUPPORTED;

  /* Check conversion */
  if( saf->format != daf->format )	return (void *)ret;

  if( flags & XMM_FILTER_AOF_CMPCHAN )
	if( saf->channels != daf->channels )	return (void *)ret;

  if( flags & XMM_FILTER_AOF_CMPSRATE )
	if( saf->samprate != daf->samprate )	return (void *)ret;

  if( flags & XMM_FILTER_AOF_CMPBRATE )
	if( saf->bitrate != daf->bitrate )	return (void *)ret;

  /* Only query filter */
  if( flags & XMM_FILTER_AOF_QUERY )	return (void *)NULL;

  /* Allocate filter */
  if(( pFilter = xmm_memdup_x( &plugin_info, sizeof( XMM_PluginFilterAudio ), sizeof( struct priv_t ))) == NULL )
  {
	xmm_SetError( xmm, XMM_RET_ALLOC, "(NULL) Unable to duplicate plugin_info" );
	return NULL;
  }

  priv = (struct priv_t *) &pFilter[1];
  pFilter->sys.priv = (void *) priv;
  pFilter->sys.xmm = xmm;

  /* Allocate memory */
  if(( priv->daf = malloc( sizeof( XMM_AudioFormat ) + daf->extraSize )) == NULL )
  {
	xmm_SetError( xmm, XMM_RET_ALLOC, "(NULL) XMM_AudioFormat" );
	return NULL;
  }

  /* Save destination format */
  memcpy( priv->daf, saf, sizeof(XMM_AudioFormat) + priv->daf->extraSize );

  if( !( flags & XMM_FILTER_AOF_DESTRO ))
  {
	memcpy( daf, saf, sizeof(XMM_AudioFormat));
	daf->extraSize = 0;
  }

  return pFilter;
}

/*
 * Free filter
 */
static int null_Close( XMM_PluginFilterAudio *filter )
{
  struct priv_t		*priv = filter->sys.priv;

  if( priv->daf )	free( priv->daf );
  free( filter );

  return XMM_RET_OK;
}

/*
 * Filter control
 */
static int null_Control( XMM_PluginFilterAudio *filter, uint32_t cmd, uint32_t param, void *data )
{
  struct priv_t		*priv = filter->sys.priv;

  switch( cmd )
  {
	case XMM_CTLGET_DATA_SSIZE:
		*((uint32_t *)data) = param;
		return XMM_CTLRET_ARG;			/* Result in arg */

	case XMM_CTLGET_AFORMAT_PTR:			/* Get sound format */
		*((XMM_AudioFormat **) data) = priv->daf;
		return XMM_CTLRET_ARG;			/* Result in arg */

	case XMM_CTLGET_FILTER_INFO:
		*((XMM_FilterAudioInfo **)data) = &null_fai;
		return XMM_CTLRET_ARG;			/* Result in arg */

	case XMM_CTLSET_FLUSH:
		return XMM_CTLRET_TRUE;

	default:
		break;
  }

  if( cmd & XMM_CTLMASK_AFILTER )
	return xmm_SetError( filter->sys.xmm, XMM_RET_NOTSUPPORTED, "(NULL) cmd = 0x%x" );

  return xmm_SetError( filter->sys.xmm, XMM_RET_INVALID_ARG, "(NULL) cmd ( 0x%x )" );
}

/*
 * Process data
 */
static int null_Process( XMM_PluginFilterAudio *filter, uint8_t *src, uint32_t isize, uint8_t *dest, uint32_t *osize, uint32_t *flags )
{
  memcpy( dest, src, isize );

  *osize = isize;
  return isize;
}

/*
 * Process data (BQ)
 */
static int null_ProcessBQ( XMM_PluginFilterAudio *filter, XMM_BufferQueue *bq, uint8_t *dest, uint32_t *osize, uint32_t *flags )
{
  return XMM_RET_NOTSUPPORTED;
}

/*
 * Plugin data
 */
XMM_PluginFilterAudio plugin_info = {{ NULL,
				XMM_PLUGIN_ID,
				XMM_PLUGIN_TYPE_AFILTER,
				XMM_FILTER_FLAG_ACODEC,
				XMM_VERSION_NUM,
				"",
				"NULL",
				"Codec: NULL (copy)",
				"Copyright (c) 2002 Arthur Kleer",
				NULL, NULL },
				null_Open, null_Close, null_Control,
				null_Process, null_ProcessBQ };
