/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_wma_h
#define INC_wma_h

/*
 * Definitions
 */

#define	WMA_USE_ACM
#define	WMA_USE_DS

/* Change 'undef' in 'define' for verbose mode */
#ifndef VERBOSE
//#define	VERBOSE
#endif

/* Weed need at least one of (WMA_USE_ACM,WMA_USE_DS) */
#if !defined(WMA_USE_ACM) && !defined(WMA_USE_DS)
#error "No WMA decoder enabled"
#endif

/*
 * Types
 */

typedef struct decoder_s	decoder_t;

struct decoder_s
{
    int		(*Open)( void *xmm, decoder_t *decoder, XMM_AudioFormat *af );
    int		(*Close)( void *xmm, decoder_t *decoder );
    int		(*SourceSize)( void *xmm, decoder_t *decoder, uint32_t dsize, uint32_t *ssize );
    int		(*Convert)( void *xmm, decoder_t *decoder, uint8_t *src, uint32_t isize, uint8_t *dest, uint32_t *osize, int *flags );
    void	*priv;
};

/*
 * Prototypes
 */

int wma_decoder_init_acm( void *xmm, decoder_t *decoder );
int wma_decoder_init_ds( void *xmm, decoder_t *decoder );

#endif
