/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * svga_kb.c
 * SVGA library keyboard event
 */

/* Change 'undef' in 'define' to get debug info */
#ifndef DEBUG
#undef	DEBUG
#endif

/*
 * Includes
 */

#include <vga.h>
#include <vgakeyboard.h>
#include "svga_kb.h"

#ifdef DEBUG
#include <stdio.h>
#endif

/*
 * Definitions
 */

#define	KEYBOARD_BUFFERSIZE	0x80
#define	KEYBOARD_PROCESS	0x02

/*
 * Global data
 */

int                     keyboard_mBuffer[KEYBOARD_BUFFERSIZE];     

/*
 * Prototypes
 */

static void svga_keyboard_Handler( int scancode, int press );

/*
 * Initialize keyboard
 */

int svga_keyboard_Init( void )
{
  int	i;

  keyboard_init(); 
  keyboard_seteventhandler((__keyboard_handler) svga_keyboard_Handler );

  for( i = 0; i < KEYBOARD_BUFFERSIZE; i++)	keyboard_mBuffer[i] = 0;

  return 0;
}

/*
 * Deinitialize keyboard
 */

int svga_keyboard_Exit( void )
{
  keyboard_clearstate();
  keyboard_setdefaulteventhandler();
  keyboard_close();

  return 0;
}

/*
 * Poll Event
 */

int svga_keyboard_PollEvent( int *scancode, int *state )
{
  int i;

  /* Check for event */
  keyboard_update();

  /* Find unprocessed events */
  for( i = 0; i < KEYBOARD_BUFFERSIZE; i++ )
    if( keyboard_mBuffer[i] & KEYBOARD_PROCESS )
    {
	keyboard_mBuffer[i] &= ~KEYBOARD_PROCESS;

	*scancode = i;
	*state = keyboard_mBuffer[i];

#if DEBUG
	printf( "SVGA! PollEvent() scancode = %i state = %i\n", *scancode, *state );
#endif
	return 1;
    }

  return 0;
}

/*
 * Keyboard handler, called on keyboard_update()
 */

static void svga_keyboard_Handler( int scancode, int press )
{
  if((( keyboard_mBuffer[scancode] & ~KEYBOARD_PROCESS ) != press ))
  {
#if DEBUG
	printf( "SVGA! Handler called: scancode %i, state %i\n", scancode, press );
#endif
	keyboard_mBuffer[scancode] = press | KEYBOARD_PROCESS;
  }
}
